package net.ibizsys.codegen.template.rtmodel.dsl.wf;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class WFVersionWriter extends net.ibizsys.codegen.template.rtmodel.dsl.ModelObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.wf.IPSWFVersion iPSWFVersion = (net.ibizsys.model.wf.IPSWFVersion)object;
		
		this.write(writer, "codeName", iPSWFVersion.getCodeName(), "", indent);
		if(iPSWFVersion.getPSWFProcesses() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.wf.IPSWFVersion.class, "getPSWFProcesses", false)){
			writer.write(indent);
			writer.write("wfprocesses {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFProcessListWriter.class, writer, iPSWFVersion.getPSWFProcesses(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "workflow", iPSWFVersion.getPSWorkflow(), null, indent);
		this.write(writer, "startWFProcess", iPSWFVersion.getStartPSWFProcess(), null, indent);
		this.write(writer, "wfcodeName", iPSWFVersion.getWFCodeName(), "", indent);
		this.write(writer, "version", iPSWFVersion.getWFVersion(), "0", indent);
		this.write(writer, "hasMobStartView", iPSWFVersion.hasMobStartView(), "false", indent);
		this.write(writer, "hasStartView", iPSWFVersion.hasStartView(), "false", indent);
		this.write(writer, "valid", iPSWFVersion.isValid(), "false", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.wf.IPSWFVersion iPSWFVersion = (net.ibizsys.model.wf.IPSWFVersion)object;
		
		//默认不导出
		if(iPSWFVersion.getPSWFProcesses() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.wf.IPSWFVersion.class, "getPSWFProcesses", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFProcessListWriter.class, iPSWFVersion.getPSWFProcesses());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}