package net.ibizsys.codegen.template.rtmodel.dsl.wf;

import java.io.Writer;
import java.util.List;
import net.ibizsys.codegen.template.rtmodel.dsl.ModelListWriterBase;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class WFProcessListWriter extends ModelListWriterBase<net.ibizsys.model.wf.IPSWFProcess>{
	@Override
	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, List<net.ibizsys.model.wf.IPSWFProcess> list, String indent) throws Exception {
		for(net.ibizsys.model.wf.IPSWFProcess item : list) {
			if("CALLORGACTIVITY".equals(item.getWFProcessType())){
				writer.write(indent);
				writer.write("callorgactivity {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFCallOrgActivityProcessWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("EMBED".equals(item.getWFProcessType())){
				writer.write(indent);
				writer.write("embed {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFEmbedWFProcessWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("END".equals(item.getWFProcessType())){
				writer.write(indent);
				writer.write("end {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFEndProcessWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("EXCLUSIVEGATEWAY".equals(item.getWFProcessType())){
				writer.write(indent);
				writer.write("exclusivegateway {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFExclusiveGatewayProcessWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("INCLUSIVEGATEWAY".equals(item.getWFProcessType())){
				writer.write(indent);
				writer.write("inclusivegateway {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFInclusiveGatewayProcessWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("INTERACTIVE".equals(item.getWFProcessType())){
				writer.write(indent);
				writer.write("interactive {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFInteractiveProcessWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("PARALLEL".equals(item.getWFProcessType())){
				writer.write(indent);
				writer.write("parallel {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFParallelSubWFProcessWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("PARALLELGATEWAY".equals(item.getWFProcessType())){
				writer.write(indent);
				writer.write("parallelgateway {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFParallelGatewayProcessWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("PROCESS".equals(item.getWFProcessType())){
				writer.write(indent);
				writer.write("process {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFDEActionProcessWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("START".equals(item.getWFProcessType())){
				writer.write(indent);
				writer.write("start {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFStartProcessWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("TIMEREVENT".equals(item.getWFProcessType())){
				writer.write(indent);
				writer.write("timerevent {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFTimerEventProcessWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			
			writer.write(indent);
			writer.write("item {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFProcessWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//super.onWrite(writer, list, indent);
	}
	
	@Override
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, List<net.ibizsys.model.wf.IPSWFProcess> list) throws Exception {
		for(net.ibizsys.model.wf.IPSWFProcess item : list) {
			if("CALLORGACTIVITY".equals(item.getWFProcessType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFCallOrgActivityProcessWriter.class, item, "WFProcess");
				continue;
			}
			if("EMBED".equals(item.getWFProcessType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFEmbedWFProcessWriter.class, item, "WFProcess");
				continue;
			}
			if("END".equals(item.getWFProcessType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFEndProcessWriter.class, item, "WFProcess");
				continue;
			}
			if("EXCLUSIVEGATEWAY".equals(item.getWFProcessType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFExclusiveGatewayProcessWriter.class, item, "WFProcess");
				continue;
			}
			if("INCLUSIVEGATEWAY".equals(item.getWFProcessType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFInclusiveGatewayProcessWriter.class, item, "WFProcess");
				continue;
			}
			if("INTERACTIVE".equals(item.getWFProcessType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFInteractiveProcessWriter.class, item, "WFProcess");
				continue;
			}
			if("PARALLEL".equals(item.getWFProcessType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFParallelSubWFProcessWriter.class, item, "WFProcess");
				continue;
			}
			if("PARALLELGATEWAY".equals(item.getWFProcessType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFParallelGatewayProcessWriter.class, item, "WFProcess");
				continue;
			}
			if("PROCESS".equals(item.getWFProcessType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFDEActionProcessWriter.class, item, "WFProcess");
				continue;
			}
			if("START".equals(item.getWFProcessType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFStartProcessWriter.class, item, "WFProcess");
				continue;
			}
			if("TIMEREVENT".equals(item.getWFProcessType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFTimerEventProcessWriter.class, item, "WFProcess");
				continue;
			}
			
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFProcessWriter.class, item, "WFProcess");
		}
		//super.onExport(root, list);
	}
	
}