package net.ibizsys.codegen.template.rtmodel.dsl.wf;

import java.io.Writer;
import java.util.List;
import net.ibizsys.codegen.template.rtmodel.dsl.ModelListWriterBase;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class WFLinkCondListWriter extends ModelListWriterBase<net.ibizsys.model.wf.IPSWFLinkCond>{
	@Override
	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, List<net.ibizsys.model.wf.IPSWFLinkCond> list, String indent) throws Exception {
		for(net.ibizsys.model.wf.IPSWFLinkCond item : list) {
			if("GROUP".equals(item.getCondType())){
				writer.write(indent);
				writer.write("group {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFLinkGroupCondWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("SINGLE".equals(item.getCondType())){
				writer.write(indent);
				writer.write("single {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFLinkSingleCondWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
		}
		//super.onWrite(writer, list, indent);
	}
	
	@Override
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, List<net.ibizsys.model.wf.IPSWFLinkCond> list) throws Exception {
		for(net.ibizsys.model.wf.IPSWFLinkCond item : list) {
			if("GROUP".equals(item.getCondType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFLinkGroupCondWriter.class, item, "WFLinkCond");
				continue;
			}
			if("SINGLE".equals(item.getCondType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFLinkSingleCondWriter.class, item, "WFLinkCond");
				continue;
			}
		}
		//super.onExport(root, list);
	}
	
}