package net.ibizsys.codegen.template.rtmodel.dsl.wf;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class WFInteractiveLinkWriter extends net.ibizsys.codegen.template.rtmodel.dsl.wf.WFLinkWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.wf.IPSWFInteractiveLink iPSWFInteractiveLink = (net.ibizsys.model.wf.IPSWFInteractiveLink)object;
		
		this.write(writer, "formCodeName", iPSWFInteractiveLink.getFormCodeName(), "", indent);
		this.write(writer, "fromWFProcess", iPSWFInteractiveLink.getFromPSWFProcess(), null, indent);
		this.write(writer, "mobFormCodeName", iPSWFInteractiveLink.getMobFormCodeName(), "", indent);
		this.write(writer, "mobViewCodeName", iPSWFInteractiveLink.getMobViewCodeName(), "", indent);
		if(iPSWFInteractiveLink.getPSWFLinkRoles() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.wf.IPSWFInteractiveLink.class, "getPSWFLinkRoles", false)){
			writer.write(indent);
			writer.write("wflinkRoles {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFLinkRoleListWriter.class, writer, iPSWFInteractiveLink.getPSWFLinkRoles(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "viewCodeName", iPSWFInteractiveLink.getViewCodeName(), "", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.wf.IPSWFInteractiveLink iPSWFInteractiveLink = (net.ibizsys.model.wf.IPSWFInteractiveLink)object;
		
		//默认不导出
		if(iPSWFInteractiveLink.getPSWFLinkRoles() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.wf.IPSWFInteractiveLink.class, "getPSWFLinkRoles", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.wf.WFLinkRoleListWriter.class, iPSWFInteractiveLink.getPSWFLinkRoles());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}