package net.ibizsys.codegen.template.rtmodel.dsl.testing;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class SysTestModuleWriter extends net.ibizsys.codegen.template.rtmodel.dsl.ModelObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.testing.IPSSysTestModule iPSSysTestModule = (net.ibizsys.model.testing.IPSSysTestModule)object;
		
		this.write(writer, "codeName", iPSSysTestModule.getCodeName(), "", indent);
		this.write(writer, "moduleTag", iPSSysTestModule.getModuleTag(), "", indent);
		this.write(writer, "moduleTag2", iPSSysTestModule.getModuleTag2(), "", indent);
		if(iPSSysTestModule.getPSSysTestCases() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.testing.IPSSysTestModule.class, "getPSSysTestCases", false)){
			writer.write(indent);
			writer.write("sysTestCases {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.testing.SysTestCaseListWriter.class, writer, iPSSysTestModule.getPSSysTestCases(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.testing.IPSSysTestModule iPSSysTestModule = (net.ibizsys.model.testing.IPSSysTestModule)object;
		
		//默认不导出
		if(iPSSysTestModule.getPSSysTestCases() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.testing.IPSSysTestModule.class, "getPSSysTestCases", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.testing.SysTestCaseListWriter.class, iPSSysTestModule.getPSSysTestCases());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}