package net.ibizsys.codegen.template.rtmodel.dsl.testing;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class SysTestCaseWriter extends net.ibizsys.codegen.template.rtmodel.dsl.ModelObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.testing.IPSSysTestCase iPSSysTestCase = (net.ibizsys.model.testing.IPSSysTestCase)object;
		
		this.write(writer, "assertExceptionData", iPSSysTestCase.getAssertExceptionData(), "", indent);
		this.write(writer, "assertExceptionData2", iPSSysTestCase.getAssertExceptionData2(), "", indent);
		this.write(writer, "assertExceptionName", iPSSysTestCase.getAssertExceptionName(), "", indent);
		this.write(writer, "assertType", iPSSysTestCase.getAssertType(), "", indent);
		this.write(writer, "codeName", iPSSysTestCase.getCodeName(), "", indent);
		this.write(writer, "orderValue", iPSSysTestCase.getOrderValue(), "99999", indent);
		this.write(writer, "dataEntity", iPSSysTestCase.getPSDataEntity(), null, indent);
		if(iPSSysTestCase.getPSSysTestCaseInputs() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.testing.IPSSysTestCase.class, "getPSSysTestCaseInputs", false)){
			writer.write(indent);
			writer.write("inputs {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.testing.SysTestCaseInputListWriter.class, writer, iPSSysTestCase.getPSSysTestCaseInputs(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "sysTestData", iPSSysTestCase.getPSSysTestData(), null, indent);
		this.write(writer, "testCaseSN", iPSSysTestCase.getTestCaseSN(), "", indent);
		this.write(writer, "testCaseType", iPSSysTestCase.getTestCaseType(), "", indent);
		this.write(writer, "rollbackTransaction", iPSSysTestCase.isRollbackTransaction(), "false", indent);
		
		net.ibizsys.model.testing.IPSDEFVRTestCase iPSDEFVRTestCase = (net.ibizsys.model.testing.IPSDEFVRTestCase)object;
		
		this.write(writer, "defield", iPSDEFVRTestCase.getPSDEField(), null, indent);
		
		net.ibizsys.model.testing.IPSDEActionTestCase iPSDEActionTestCase = (net.ibizsys.model.testing.IPSDEActionTestCase)object;
		
		this.write(writer, "deaction", iPSDEActionTestCase.getPSDEAction(), null, indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.testing.IPSSysTestCase iPSSysTestCase = (net.ibizsys.model.testing.IPSSysTestCase)object;
		
		//默认不导出
		if(iPSSysTestCase.getPSSysTestCaseInputs() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.testing.IPSSysTestCase.class, "getPSSysTestCaseInputs", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.testing.SysTestCaseInputListWriter.class, iPSSysTestCase.getPSSysTestCaseInputs());
		}
		
		net.ibizsys.model.testing.IPSDEFVRTestCase iPSDEFVRTestCase = (net.ibizsys.model.testing.IPSDEFVRTestCase)object;
		
		
		net.ibizsys.model.testing.IPSDEActionTestCase iPSDEActionTestCase = (net.ibizsys.model.testing.IPSDEActionTestCase)object;
		

		super.onExport(iModelDSLGenEngineContext, object);
	}
}