package net.ibizsys.codegen.template.rtmodel.dsl.system;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class SystemModuleWriter extends net.ibizsys.codegen.template.rtmodel.dsl.ModelObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.system.IPSSystemModule iPSSystemModule = (net.ibizsys.model.system.IPSSystemModule)object;
		
		this.write(writer, "codeName", iPSSystemModule.getCodeName(), "", indent);
		this.write(writer, "dslink", iPSSystemModule.getDSLink(), "", indent);
		this.write(writer, "moduleSN", iPSSystemModule.getModuleSN(), "", indent);
		this.write(writer, "moduleTag", iPSSystemModule.getModuleTag(), "", indent);
		this.write(writer, "moduleTag2", iPSSystemModule.getModuleTag2(), "", indent);
		this.write(writer, "moduleTag3", iPSSystemModule.getModuleTag3(), "", indent);
		this.write(writer, "moduleTag4", iPSSystemModule.getModuleTag4(), "", indent);
		this.write(writer, "pkgcodeName", iPSSystemModule.getPKGCodeName(), "", indent);
		this.write(writer, "sysModelGroup", iPSSystemModule.getPSSysModelGroup(), null, indent);
		this.write(writer, "sysRef", iPSSystemModule.getPSSysRef(), null, indent);
		this.write(writer, "sysSFPlugin", iPSSystemModule.getPSSysSFPlugin(), "", indent);
		this.write(writer, "sysRefType", iPSSystemModule.getSysRefType(), "", indent);
		this.write(writer, "utilParams", iPSSystemModule.getUtilParams(), "", indent);
		this.write(writer, "utilTag", iPSSystemModule.getUtilTag(), "", indent);
		this.write(writer, "utilType", iPSSystemModule.getUtilType(), "", indent);
		this.write(writer, "defaultModule", iPSSystemModule.isDefaultModule(), "false", indent);
		this.write(writer, "subSysAsCloud", iPSSystemModule.isSubSysAsCloud(), "false", indent);
		this.write(writer, "subSysModule", iPSSystemModule.isSubSysModule(), "false", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.system.IPSSystemModule iPSSystemModule = (net.ibizsys.model.system.IPSSystemModule)object;
		

		super.onExport(iModelDSLGenEngineContext, object);
	}
}