package net.ibizsys.codegen.template.rtmodel.dsl.res;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class SysI18NWriter extends net.ibizsys.codegen.template.rtmodel.dsl.ModelObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.res.IPSSysI18N iPSSysI18N = (net.ibizsys.model.res.IPSSysI18N)object;
		
		if(iPSSysI18N.getAllPSLanguageReses() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.res.IPSSysI18N.class, "getAllPSLanguageReses", false)){
			writer.write(indent);
			writer.write("languageReses {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.res.LanguageResListWriter.class, writer, iPSSysI18N.getAllPSLanguageReses(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSysI18N.getAllPSSysLans() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.res.IPSSysI18N.class, "getAllPSSysLans", false)){
			writer.write(indent);
			writer.write("sysLans {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.res.SysLanListWriter.class, writer, iPSSysI18N.getAllPSSysLans(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.res.IPSSysI18N iPSSysI18N = (net.ibizsys.model.res.IPSSysI18N)object;
		
		//默认不导出
		if(iPSSysI18N.getAllPSLanguageReses() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.res.IPSSysI18N.class, "getAllPSLanguageReses", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.res.LanguageResListWriter.class, iPSSysI18N.getAllPSLanguageReses());
		}
		//默认不导出
		if(iPSSysI18N.getAllPSSysLans() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.res.IPSSysI18N.class, "getAllPSSysLans", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.res.SysLanListWriter.class, iPSSysI18N.getAllPSSysLans());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}