package net.ibizsys.codegen.template.rtmodel.dsl.dataentity.service;

import java.io.Writer;
import java.util.List;
import net.ibizsys.codegen.template.rtmodel.dsl.ModelListWriterBase;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class DEMethodDTOListWriter extends ModelListWriterBase<net.ibizsys.model.dataentity.service.IPSDEMethodDTO>{
	@Override
	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, List<net.ibizsys.model.dataentity.service.IPSDEMethodDTO> list, String indent) throws Exception {
		for(net.ibizsys.model.dataentity.service.IPSDEMethodDTO item : list) {
			if("DEACTIONINPUT".equals(item.getType())){
				writer.write(indent);
				writer.write("deactioninput {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.action.DEActionInputDTOWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("DEFILTER".equals(item.getType())){
				writer.write(indent);
				writer.write("defilter {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.ds.DEFilterDTOWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("LINK".equals(item.getType())){
				writer.write(indent);
				writer.write("link {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.service.LinkDEMethodDTOWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			
			writer.write(indent);
			writer.write("item {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.service.DEMethodDTOWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//super.onWrite(writer, list, indent);
	}
	
	@Override
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, List<net.ibizsys.model.dataentity.service.IPSDEMethodDTO> list) throws Exception {
		for(net.ibizsys.model.dataentity.service.IPSDEMethodDTO item : list) {
			if("DEACTIONINPUT".equals(item.getType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.action.DEActionInputDTOWriter.class, item, "DEMethodDTO");
				continue;
			}
			if("DEFILTER".equals(item.getType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.ds.DEFilterDTOWriter.class, item, "DEMethodDTO");
				continue;
			}
			if("LINK".equals(item.getType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.service.LinkDEMethodDTOWriter.class, item, "DEMethodDTO");
				continue;
			}
			
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.service.DEMethodDTOWriter.class, item, "DEMethodDTO");
		}
		//super.onExport(root, list);
	}
	
}