package net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic;

import java.io.Writer;
import java.util.List;
import net.ibizsys.codegen.template.rtmodel.dsl.ModelListWriterBase;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class DELogicNodeListWriter extends ModelListWriterBase<net.ibizsys.model.dataentity.logic.IPSDELogicNode>{
	@Override
	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, List<net.ibizsys.model.dataentity.logic.IPSDELogicNode> list, String indent) throws Exception {
		for(net.ibizsys.model.dataentity.logic.IPSDELogicNode item : list) {
			if("APPENDPARAM".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("appendparam {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicAppendParamNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("BEGIN".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("begin {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicBeginNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("BINDPARAM".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("bindparam {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicBindParamNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("COPYPARAM".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("copyparam {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicCopyParamNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("DEACTION".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("deaction {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicDEActionNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("DEBUGPARAM".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("debugparam {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicDebugParamNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("DEDATAQUERY".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("dedataquery {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicDEDataQueryNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("DEDATASET".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("dedataset {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicDEDataSetNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("DEDATASYNC".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("dedatasync {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicDEDataSyncNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("DEDTSQUEUE".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("dedtsqueue {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicDEDTSQueueNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("DELOGIC".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("delogic {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicDELogicNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("DENOTIFY".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("denotify {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicDENotifyNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("DEPRINT".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("deprint {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicDEPrintNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("DEREPORT".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("dereport {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicDEReportNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("END".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("end {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicEndNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("PREPAREPARAM".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("prepareparam {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicPrepareParamNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("RAWSFCODE".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("rawsfcode {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicRawCodeNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("RAWSQLANDLOOPCALL".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("rawsqlandloopcall {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicRawSqlAndLoopNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("RAWSQLCALL".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("rawsqlcall {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicRawSqlNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("RAWWEBCALL".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("rawwebcall {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicWebClientNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("RENEWPARAM".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("renewparam {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicRenewParamNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("RESETPARAM".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("resetparam {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicResetParamNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("SFPLUGIN".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("sfplugin {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicPluginNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("SORTPARAM".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("sortparam {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicSortParamNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("STARTWF".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("startwf {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicStartWFNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("SUBSYSSAMETHOD".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("subsyssamethod {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicSubSysSAMethodNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("SYSBDTABLEACTION".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("sysbdtableaction {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicSysBDTableNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("SYSDATASYNCAGENTOUT".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("sysdatasyncagentout {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicSysDataSyncAgentNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("SYSDBTABLEACTION".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("sysdbtableaction {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicSysDBTableNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("SYSLOGIC".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("syslogic {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicSysLogicNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("SYSSEARCHDOCACTION".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("syssearchdocaction {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicSysSearchDocNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("SYSUTIL".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("sysutil {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicSysUtilNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("THROWEXCEPTION".equals(item.getLogicNodeType())){
				writer.write(indent);
				writer.write("throwexception {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicErrorNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			
			writer.write(indent);
			writer.write("item {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.DELogicNodeWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//super.onWrite(writer, list, indent);
	}
	
	@Override
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, List<net.ibizsys.model.dataentity.logic.IPSDELogicNode> list) throws Exception {
		for(net.ibizsys.model.dataentity.logic.IPSDELogicNode item : list) {
			if("APPENDPARAM".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicAppendParamNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("BEGIN".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicBeginNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("BINDPARAM".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicBindParamNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("COPYPARAM".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicCopyParamNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("DEACTION".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicDEActionNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("DEBUGPARAM".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicDebugParamNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("DEDATAQUERY".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicDEDataQueryNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("DEDATASET".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicDEDataSetNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("DEDATASYNC".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicDEDataSyncNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("DEDTSQUEUE".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicDEDTSQueueNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("DELOGIC".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicDELogicNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("DENOTIFY".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicDENotifyNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("DEPRINT".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicDEPrintNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("DEREPORT".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicDEReportNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("END".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicEndNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("PREPAREPARAM".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicPrepareParamNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("RAWSFCODE".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicRawCodeNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("RAWSQLANDLOOPCALL".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicRawSqlAndLoopNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("RAWSQLCALL".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicRawSqlNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("RAWWEBCALL".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicWebClientNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("RENEWPARAM".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicRenewParamNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("RESETPARAM".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicResetParamNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("SFPLUGIN".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicPluginNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("SORTPARAM".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicSortParamNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("STARTWF".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicStartWFNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("SUBSYSSAMETHOD".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicSubSysSAMethodNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("SYSBDTABLEACTION".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicSysBDTableNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("SYSDATASYNCAGENTOUT".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicSysDataSyncAgentNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("SYSDBTABLEACTION".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicSysDBTableNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("SYSLOGIC".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicSysLogicNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("SYSSEARCHDOCACTION".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicSysSearchDocNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("SYSUTIL".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicSysUtilNodeWriter.class, item, "DELogicNode");
				continue;
			}
			if("THROWEXCEPTION".equals(item.getLogicNodeType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.IDELogicErrorNodeWriter.class, item, "DELogicNode");
				continue;
			}
			
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.DELogicNodeWriter.class, item, "DELogicNode");
		}
		//super.onExport(root, list);
	}
	
}