package net.ibizsys.codegen.template.rtmodel.dsl.dataentity.ds;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class DEDataQueryWriter extends net.ibizsys.codegen.template.rtmodel.dsl.dataentity.DataEntityObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.dataentity.ds.IPSDEDataQuery iPSDEDataQuery = (net.ibizsys.model.dataentity.ds.IPSDEDataQuery)object;
		
		if(iPSDEDataQuery.getAllPSDEDataQueryCodes() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.ds.IPSDEDataQuery.class, "getAllPSDEDataQueryCodes", false)){
			writer.write(indent);
			writer.write("codes {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.ds.DEDataQueryCodeListWriter.class, writer, iPSDEDataQuery.getAllPSDEDataQueryCodes(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "codeName", iPSDEDataQuery.getCodeName(), "", indent);
		this.write(writer, "defgroupType", iPSDEDataQuery.getDEFGroupType(), "", indent);
		this.write(writer, "extendMode", iPSDEDataQuery.getExtendMode(), "0", indent);
		this.write(writer, "logicName", iPSDEDataQuery.getLogicName(), "", indent);
		if(iPSDEDataQuery.getPSDEDQMain() != null){
			writer.write(indent);
			writer.write("dedqmain {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.ds.DEDQMainWriter.class, writer, iPSDEDataQuery.getPSDEDQMain(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDEDataQuery.getPSDEDataQueryInput() != null){
			writer.write(indent);
			writer.write("input {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.ds.DEDataQueryInputWriter.class, writer, iPSDEDataQuery.getPSDEDataQueryInput(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDEDataQuery.getPSDEDataQueryReturn() != null){
			writer.write(indent);
			writer.write("'return' {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.ds.DEDataQueryReturnWriter.class, writer, iPSDEDataQuery.getPSDEDataQueryReturn(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "defgroup", iPSDEDataQuery.getPSDEFGroup(), null, indent);
		this.write(writer, "viewLevel", iPSDEDataQuery.getViewLevel(), "-1", indent);
		this.write(writer, "customCode", iPSDEDataQuery.isCustomCode(), "false", indent);
		this.write(writer, "defaultMode", iPSDEDataQuery.isDefaultMode(), "false", indent);
		this.write(writer, "privQuery", iPSDEDataQuery.isPrivQuery(), "false", indent);
		this.write(writer, "pubServiceDefault", iPSDEDataQuery.isPubServiceDefault(), "false", indent);
		this.write(writer, "queryFromView", iPSDEDataQuery.isQueryFromView(), "false", indent);
		
		net.ibizsys.model.IPSModelSortable iPSModelSortable = (net.ibizsys.model.IPSModelSortable)object;
		
		this.write(writer, "orderValue", iPSModelSortable.getOrderValue(), "99999", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.dataentity.ds.IPSDEDataQuery iPSDEDataQuery = (net.ibizsys.model.dataentity.ds.IPSDEDataQuery)object;
		
		//默认不导出
		if(iPSDEDataQuery.getAllPSDEDataQueryCodes() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.ds.IPSDEDataQuery.class, "getAllPSDEDataQueryCodes", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.ds.DEDataQueryCodeListWriter.class, iPSDEDataQuery.getAllPSDEDataQueryCodes());
		}
		
		net.ibizsys.model.IPSModelSortable iPSModelSortable = (net.ibizsys.model.IPSModelSortable)object;
		

		super.onExport(iModelDSLGenEngineContext, object);
	}
}