package net.ibizsys.codegen.template.rtmodel.dsl.dataentity.der;

import java.io.Writer;
import java.util.List;
import net.ibizsys.codegen.template.rtmodel.dsl.ModelListWriterBase;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class DERListWriter extends ModelListWriterBase<net.ibizsys.model.dataentity.der.IPSDERBase>{
	@Override
	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, List<net.ibizsys.model.dataentity.der.IPSDERBase> list, String indent) throws Exception {
		for(net.ibizsys.model.dataentity.der.IPSDERBase item : list) {
			if("DER11".equals(item.getDERType())){
				writer.write(indent);
				writer.write("der11 {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.der.DER11Writer.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("DER1N".equals(item.getDERType())){
				writer.write(indent);
				writer.write("der1n {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.der.DER1NWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("DERAGGDATA".equals(item.getDERType())){
				writer.write(indent);
				writer.write("deraggdata {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.der.DERAggDataWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("DERCUSTOM".equals(item.getDERType())){
				writer.write(indent);
				writer.write("dercustom {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.der.DERCustomWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("DERINDEX".equals(item.getDERType())){
				writer.write(indent);
				writer.write("derindex {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.der.DERIndexWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("DERINHERIT".equals(item.getDERType())){
				writer.write(indent);
				writer.write("derinherit {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.der.DERInheritWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("DERMULINH".equals(item.getDERType())){
				writer.write(indent);
				writer.write("dermulinh {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.der.DERMultiInheritWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			
			writer.write(indent);
			writer.write("item {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.der.DERWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//super.onWrite(writer, list, indent);
	}
	
	@Override
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, List<net.ibizsys.model.dataentity.der.IPSDERBase> list) throws Exception {
		for(net.ibizsys.model.dataentity.der.IPSDERBase item : list) {
			if("DER11".equals(item.getDERType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.der.DER11Writer.class, item, "DER");
				continue;
			}
			if("DER1N".equals(item.getDERType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.der.DER1NWriter.class, item, "DER");
				continue;
			}
			if("DERAGGDATA".equals(item.getDERType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.der.DERAggDataWriter.class, item, "DER");
				continue;
			}
			if("DERCUSTOM".equals(item.getDERType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.der.DERCustomWriter.class, item, "DER");
				continue;
			}
			if("DERINDEX".equals(item.getDERType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.der.DERIndexWriter.class, item, "DER");
				continue;
			}
			if("DERINHERIT".equals(item.getDERType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.der.DERInheritWriter.class, item, "DER");
				continue;
			}
			if("DERMULINH".equals(item.getDERType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.der.DERMultiInheritWriter.class, item, "DER");
				continue;
			}
			
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.der.DERWriter.class, item, "DER");
		}
		//super.onExport(root, list);
	}
	
}