package net.ibizsys.codegen.template.rtmodel.dsl.dataentity.der;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class DERGroupWriter extends net.ibizsys.codegen.template.rtmodel.dsl.dataentity.DataEntityObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.dataentity.der.IPSDERGroup iPSDERGroup = (net.ibizsys.model.dataentity.der.IPSDERGroup)object;
		
		this.write(writer, "codeName", iPSDERGroup.getCodeName(), "", indent);
		this.write(writer, "codeName2", iPSDERGroup.getCodeName2(), "", indent);
		this.write(writer, "groupTag", iPSDERGroup.getGroupTag(), "", indent);
		this.write(writer, "groupTag2", iPSDERGroup.getGroupTag2(), "", indent);
		if(iPSDERGroup.getPSDERGroupDetails() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.der.IPSDERGroup.class, "getPSDERGroupDetails", false)){
			writer.write(indent);
			writer.write("details {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.der.DERGroupDetailListWriter.class, writer, iPSDERGroup.getPSDERGroupDetails(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.dataentity.der.IPSDERGroup iPSDERGroup = (net.ibizsys.model.dataentity.der.IPSDERGroup)object;
		
		//默认不导出
		if(iPSDERGroup.getPSDERGroupDetails() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.der.IPSDERGroup.class, "getPSDERGroupDetails", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.der.DERGroupDetailListWriter.class, iPSDERGroup.getPSDERGroupDetails());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}