package net.ibizsys.codegen.template.rtmodel.dsl.dataentity.dataimport;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class DEDataImportWriter extends net.ibizsys.codegen.template.rtmodel.dsl.dataentity.DataEntityObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.dataentity.dataimport.IPSDEDataImport iPSDEDataImport = (net.ibizsys.model.dataentity.dataimport.IPSDEDataImport)object;
		
		this.write(writer, "batchSize", iPSDEDataImport.getBatchSize(), "0", indent);
		this.write(writer, "codeName", iPSDEDataImport.getCodeName(), "", indent);
		this.write(writer, "createDataAccessAction", iPSDEDataImport.getCreateDataAccessAction(), "", indent);
		this.write(writer, "createDEAction", iPSDEDataImport.getCreatePSDEAction(), null, indent);
		this.write(writer, "potime", iPSDEDataImport.getPOTime(), "-1", indent);
		if(iPSDEDataImport.getPSDEDataImportItems() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.dataimport.IPSDEDataImport.class, "getPSDEDataImportItems", false)){
			writer.write(indent);
			writer.write("items {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.dataimport.DEDataImportItemListWriter.class, writer, iPSDEDataImport.getPSDEDataImportItems(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "sysPFPlugin", iPSDEDataImport.getPSSysPFPlugin(), "", indent);
		this.write(writer, "sysSFPlugin", iPSDEDataImport.getPSSysSFPlugin(), "", indent);
		this.write(writer, "updateDataAccessAction", iPSDEDataImport.getUpdateDataAccessAction(), "", indent);
		this.write(writer, "updateDEAction", iPSDEDataImport.getUpdatePSDEAction(), null, indent);
		this.write(writer, "defaultMode", iPSDEDataImport.isDefaultMode(), "false", indent);
		this.write(writer, "enableBackend", iPSDEDataImport.isEnableBackend(), "false", indent);
		this.write(writer, "ignoreError", iPSDEDataImport.isIgnoreError(), "false", indent);
		
		net.ibizsys.model.IPSModelSortable iPSModelSortable = (net.ibizsys.model.IPSModelSortable)object;
		
		this.write(writer, "orderValue", iPSModelSortable.getOrderValue(), "0", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.dataentity.dataimport.IPSDEDataImport iPSDEDataImport = (net.ibizsys.model.dataentity.dataimport.IPSDEDataImport)object;
		
		//默认不导出
		if(iPSDEDataImport.getPSDEDataImportItems() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.dataimport.IPSDEDataImport.class, "getPSDEDataImportItems", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.dataimport.DEDataImportItemListWriter.class, iPSDEDataImport.getPSDEDataImportItems());
		}
		
		net.ibizsys.model.IPSModelSortable iPSModelSortable = (net.ibizsys.model.IPSModelSortable)object;
		

		super.onExport(iModelDSLGenEngineContext, object);
	}
}