package net.ibizsys.codegen.template.rtmodel.dsl.dataentity.action;

import java.io.Writer;
import java.util.List;
import net.ibizsys.codegen.template.rtmodel.dsl.ModelListWriterBase;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class DEActionListWriter extends ModelListWriterBase<net.ibizsys.model.dataentity.action.IPSDEAction>{
	@Override
	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, List<net.ibizsys.model.dataentity.action.IPSDEAction> list, String indent) throws Exception {
		for(net.ibizsys.model.dataentity.action.IPSDEAction item : list) {
			if("DELOGIC".equals(item.getActionType())){
				writer.write(indent);
				writer.write("delogic {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.action.DELogicActionWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("REMOTE".equals(item.getActionType())){
				writer.write(indent);
				writer.write("remote {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.action.DERemoteActionWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("SCRIPT".equals(item.getActionType())){
				writer.write(indent);
				writer.write("script {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.action.DEScriptActionWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("SELECTBYKEY".equals(item.getActionType())){
				writer.write(indent);
				writer.write("selectbykey {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.action.DESelectByKeyActionWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			
			writer.write(indent);
			writer.write("item {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.action.DEUserCustomActionWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//super.onWrite(writer, list, indent);
	}
	
	@Override
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, List<net.ibizsys.model.dataentity.action.IPSDEAction> list) throws Exception {
		for(net.ibizsys.model.dataentity.action.IPSDEAction item : list) {
			if("DELOGIC".equals(item.getActionType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.action.DELogicActionWriter.class, item, "DEAction");
				continue;
			}
			if("REMOTE".equals(item.getActionType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.action.DERemoteActionWriter.class, item, "DEAction");
				continue;
			}
			if("SCRIPT".equals(item.getActionType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.action.DEScriptActionWriter.class, item, "DEAction");
				continue;
			}
			if("SELECTBYKEY".equals(item.getActionType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.action.DESelectByKeyActionWriter.class, item, "DEAction");
				continue;
			}
			
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.action.DEUserCustomActionWriter.class, item, "DEAction");
		}
		//super.onExport(root, list);
	}
	
}