package net.ibizsys.codegen.template.rtmodel.dsl.dataentity.ac;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class DEACModeWriter extends net.ibizsys.codegen.template.rtmodel.dsl.dataentity.DataEntityObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.dataentity.ac.IPSDEACMode iPSDEACMode = (net.ibizsys.model.dataentity.ac.IPSDEACMode)object;
		
		this.write(writer, "codeName", iPSDEACMode.getCodeName(), "", indent);
		this.write(writer, "emptyText", iPSDEACMode.getEmptyText(), "", indent);
		this.write(writer, "emptyTextLanguageRes", iPSDEACMode.getEmptyTextPSLanguageRes(), "", indent);
		this.write(writer, "extendMode", iPSDEACMode.getExtendMode(), "0", indent);
		this.write(writer, "itemSysPFPlugin", iPSDEACMode.getItemPSSysPFPlugin(), "", indent);
		this.write(writer, "logicName", iPSDEACMode.getLogicName(), "", indent);
		this.write(writer, "minorSortDir", iPSDEACMode.getMinorSortDir(), "", indent);
		if(iPSDEACMode.getPSDEACModeDataItems() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.ac.IPSDEACMode.class, "getPSDEACModeDataItems", false)){
			writer.write(indent);
			writer.write("dataItems {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.ac.DEACModeDataItemListWriter.class, writer, iPSDEACMode.getPSDEACModeDataItems(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "pagingSize", iPSDEACMode.getPagingSize(), "0", indent);
		this.write(writer, "defaultMode", iPSDEACMode.isDefaultMode(), "false", indent);
		this.write(writer, "enablePagingBar", iPSDEACMode.isEnablePagingBar(), "false", indent);
		
		net.ibizsys.model.IPSModelSortable iPSModelSortable = (net.ibizsys.model.IPSModelSortable)object;
		
		this.write(writer, "orderValue", iPSModelSortable.getOrderValue(), "0", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.dataentity.ac.IPSDEACMode iPSDEACMode = (net.ibizsys.model.dataentity.ac.IPSDEACMode)object;
		
		//默认不导出
		if(iPSDEACMode.getPSDEACModeDataItems() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.ac.IPSDEACMode.class, "getPSDEACModeDataItems", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.ac.DEACModeDataItemListWriter.class, iPSDEACMode.getPSDEACModeDataItems());
		}
		
		net.ibizsys.model.IPSModelSortable iPSModelSortable = (net.ibizsys.model.IPSModelSortable)object;
		

		super.onExport(iModelDSLGenEngineContext, object);
	}
}