package net.ibizsys.codegen.template.rtmodel.dsl.dataentity;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class DataEntityWriter extends net.ibizsys.codegen.template.rtmodel.dsl.ModelObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.dataentity.IPSDataEntity iPSDataEntity = (net.ibizsys.model.dataentity.IPSDataEntity)object;
		
		if(iPSDataEntity.getAllPSDEActionGroups() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEActionGroups", false)){
			writer.write(indent);
			writer.write("actionGroups {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.action.DEActionGroupListWriter.class, writer, iPSDataEntity.getAllPSDEActionGroups(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDataEntity.getAllPSDEActions() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEActions", false)){
			writer.write(indent);
			writer.write("actions {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.action.DEActionListWriter.class, writer, iPSDataEntity.getAllPSDEActions(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDataEntity.getAllPSDEDBConfigs() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEDBConfigs", false)){
			writer.write(indent);
			writer.write("dbconfigs {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.database.DEDBConfigListWriter.class, writer, iPSDataEntity.getAllPSDEDBConfigs(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDataEntity.getAllPSDEDBIndices() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEDBIndices", false)){
			writer.write(indent);
			writer.write("dbindices {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.database.DEDBIndexListWriter.class, writer, iPSDataEntity.getAllPSDEDBIndices(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDataEntity.getAllPSDEDBTables() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEDBTables", false)){
			writer.write(indent);
			writer.write("dbtables {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.database.DEDBTableListWriter.class, writer, iPSDataEntity.getAllPSDEDBTables(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDataEntity.getAllPSDEDTSQueues() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEDTSQueues", false)){
			writer.write(indent);
			writer.write("dtsqueues {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.dts.DEDTSQueueListWriter.class, writer, iPSDataEntity.getAllPSDEDTSQueues(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDataEntity.getAllPSDEDataExports() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEDataExports", false)){
			writer.write(indent);
			writer.write("dataExports {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.dataexport.DEDataExportListWriter.class, writer, iPSDataEntity.getAllPSDEDataExports(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDataEntity.getAllPSDEDataImports() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEDataImports", false)){
			writer.write(indent);
			writer.write("dataImports {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.dataimport.DEDataImportListWriter.class, writer, iPSDataEntity.getAllPSDEDataImports(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDataEntity.getAllPSDEDataQueries() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEDataQueries", false)){
			writer.write(indent);
			writer.write("dataQueries {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.ds.DEDataQueryListWriter.class, writer, iPSDataEntity.getAllPSDEDataQueries(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDataEntity.getAllPSDEDataSets() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEDataSets", false)){
			writer.write(indent);
			writer.write("dataSets {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.ds.DEDataSetListWriter.class, writer, iPSDataEntity.getAllPSDEDataSets(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDataEntity.getAllPSDEDataSyncs() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEDataSyncs", false)){
			writer.write(indent);
			writer.write("dataSyncs {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.datasync.DEDataSyncListWriter.class, writer, iPSDataEntity.getAllPSDEDataSyncs(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDataEntity.getAllPSDEFGroups() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEFGroups", false)){
			writer.write(indent);
			writer.write("defgroups {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.defield.DEFGroupListWriter.class, writer, iPSDataEntity.getAllPSDEFGroups(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDataEntity.getAllPSDEFields() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEFields", false)){
			writer.write(indent);
			writer.write("fields {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.ux.dataentity.defield.DEFieldListWriter.class, writer, iPSDataEntity.getAllPSDEFields(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDataEntity.getAllPSDEGroups() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEGroups", false)){
			writer.write(indent);
			writer.write("degroups {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.DEGroupListWriter.class, writer, iPSDataEntity.getAllPSDEGroups(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//默认导出文件
		if(iPSDataEntity.getAllPSDELogics() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDELogics", true)){
			writer.write(indent);
			writer.write("logics {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.DELogicListWriter.class, writer, iPSDataEntity.getAllPSDELogics(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDataEntity.getAllPSDEMainStates() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEMainStates", false)){
			writer.write(indent);
			writer.write("mainStates {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.mainstate.DEMainStateListWriter.class, writer, iPSDataEntity.getAllPSDEMainStates(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDataEntity.getAllPSDEMaps() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEMaps", false)){
			writer.write(indent);
			writer.write("maps {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.datamap.DEMapListWriter.class, writer, iPSDataEntity.getAllPSDEMaps(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDataEntity.getAllPSDEMethodDTOs() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEMethodDTOs", false)){
			writer.write(indent);
			writer.write("methodDTOs {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.service.DEMethodDTOListWriter.class, writer, iPSDataEntity.getAllPSDEMethodDTOs(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDataEntity.getAllPSDENotifies() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDENotifies", false)){
			writer.write(indent);
			writer.write("notifies {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.notify.DENotifyListWriter.class, writer, iPSDataEntity.getAllPSDENotifies(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDataEntity.getAllPSDEOPPrivs() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEOPPrivs", false)){
			writer.write(indent);
			writer.write("opprivs {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.priv.DEOPPrivListWriter.class, writer, iPSDataEntity.getAllPSDEOPPrivs(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDataEntity.getAllPSDEPrints() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEPrints", false)){
			writer.write(indent);
			writer.write("prints {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.print.DEPrintListWriter.class, writer, iPSDataEntity.getAllPSDEPrints(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDataEntity.getAllPSDERGroups() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDERGroups", false)){
			writer.write(indent);
			writer.write("dergroups {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.der.DERGroupListWriter.class, writer, iPSDataEntity.getAllPSDERGroups(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDataEntity.getAllPSDEReports() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEReports", false)){
			writer.write(indent);
			writer.write("reports {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.report.DEReportListWriter.class, writer, iPSDataEntity.getAllPSDEReports(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDataEntity.getAllPSDEUniStates() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEUniStates", false)){
			writer.write(indent);
			writer.write("uniStates {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.unistate.DEUniStateListWriter.class, writer, iPSDataEntity.getAllPSDEUniStates(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDataEntity.getAllPSDEUserRoles() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEUserRoles", false)){
			writer.write(indent);
			writer.write("userRoles {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.priv.DEUserRoleListWriter.class, writer, iPSDataEntity.getAllPSDEUserRoles(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDataEntity.getAllPSDEUtils() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEUtils", false)){
			writer.write(indent);
			writer.write("utils {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.util.DEUtilListWriter.class, writer, iPSDataEntity.getAllPSDEUtils(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDataEntity.getAllPSDEWFs() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEWFs", false)){
			writer.write(indent);
			writer.write("wfs {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.wf.DEWFListWriter.class, writer, iPSDataEntity.getAllPSDEWFs(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDataEntity.getAllPSModelDatas() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSModelDatas", false)){
			writer.write(indent);
			writer.write("modelDatas {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.ModelDataListWriter.class, writer, iPSDataEntity.getAllPSModelDatas(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "auditMode", iPSDataEntity.getAuditMode(), "0", indent);
		this.write(writer, "bizTag", iPSDataEntity.getBizTag(), "", indent);
		this.write(writer, "codeName", iPSDataEntity.getCodeName(), "", indent);
		this.write(writer, "detag", iPSDataEntity.getDETag(), "", indent);
		this.write(writer, "detag2", iPSDataEntity.getDETag2(), "", indent);
		this.write(writer, "detype", iPSDataEntity.getDEType(), "0", indent);
		this.write(writer, "dslink", iPSDataEntity.getDSLink(), "", indent);
		this.write(writer, "dataAccCtrlArch", iPSDataEntity.getDataAccCtrlArch(), "0", indent);
		this.write(writer, "dataAccCtrlMode", iPSDataEntity.getDataAccCtrlMode(), "0", indent);
		this.write(writer, "dataChangeLogMode", iPSDataEntity.getDataChangeLogMode(), "0", indent);
		this.write(writer, "defaultDataQuery", iPSDataEntity.getDefaultPSDEDataQuery(), null, indent);
		this.write(writer, "defaultDataSet", iPSDataEntity.getDefaultPSDEDataSet(), null, indent);
		this.write(writer, "defaultFilterDTO", iPSDataEntity.getDefaultPSDEFilterDTO(), null, indent);
		if(iPSDataEntity.getDefaultPSDEMSLogic() != null){
			writer.write(indent);
			writer.write("defaultMSLogic {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.DEMSLogicWriter.class, writer, iPSDataEntity.getDefaultPSDEMSLogic(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "defaultMethodDTO", iPSDataEntity.getDefaultPSDEMethodDTO(), null, indent);
		this.write(writer, "enableActions", iPSDataEntity.getEnableActions(), "0", indent);
		this.write(writer, "enableUIActions", iPSDataEntity.getEnableUIActions(), "0", indent);
		this.write(writer, "enableViewLevel", iPSDataEntity.getEnableViewLevel(), "0", indent);
		this.write(writer, "entityCacheTimeout", iPSDataEntity.getEntityCacheTimeout(), "-1", indent);
		this.write(writer, "extendMode", iPSDataEntity.getExtendMode(), "0", indent);
		this.write(writer, "indexDEType", iPSDataEntity.getIndexDEType(), "", indent);
		this.write(writer, "indexTypeField", iPSDataEntity.getIndexTypePSDEField(), null, indent);
		this.write(writer, "invalidLogicValue", iPSDataEntity.getInvalidLogicValue(), "", indent);
		this.write(writer, "keyField", iPSDataEntity.getKeyPSDEField(), null, indent);
		this.write(writer, "lnlanguageRes", iPSDataEntity.getLNPSLanguageRes(), "", indent);
		this.write(writer, "logicName", iPSDataEntity.getLogicName(), "", indent);
		this.write(writer, "logicValidField", iPSDataEntity.getLogicValidPSDEField(), null, indent);
		//列表数据
		if(iPSDataEntity.getMainStatePSDEFields() != null){
		}
		this.write(writer, "majorField", iPSDataEntity.getMajorPSDEField(), null, indent);
		if(iPSDataEntity.getMinorPSDERs() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getMinorPSDERs", false)){
			writer.write(indent);
			writer.write("ders {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.der.DERListWriter.class, writer, iPSDataEntity.getMinorPSDERs(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "orgIdField", iPSDataEntity.getOrgIdPSDEField(), null, indent);
		this.write(writer, "subSysServiceAPI", iPSDataEntity.getPSSubSysServiceAPI(), null, indent);
		this.write(writer, "subSysServiceAPIDE", iPSDataEntity.getPSSubSysServiceAPIDE(), null, indent);
		this.write(writer, "sysBDScheme", iPSDataEntity.getPSSysBDScheme(), null, indent);
		this.write(writer, "sysDBScheme", iPSDataEntity.getPSSysDBScheme(), null, indent);
		this.write(writer, "sysSFPlugin", iPSDataEntity.getPSSysSFPlugin(), "", indent);
		this.write(writer, "systemModule", iPSDataEntity.getPSSystemModule(), null, indent);
		this.write(writer, "saaSDCIdColumnName", iPSDataEntity.getSaaSDCIdColumnName(), "", indent);
		this.write(writer, "saaSDataIdColumnName", iPSDataEntity.getSaaSDataIdColumnName(), "", indent);
		this.write(writer, "saaSMode", iPSDataEntity.getSaaSMode(), "0", indent);
		this.write(writer, "serviceAPIMode", iPSDataEntity.getServiceAPIMode(), "0", indent);
		this.write(writer, "serviceCodeName", iPSDataEntity.getServiceCodeName(), "", indent);
		this.write(writer, "storageMode", iPSDataEntity.getStorageMode(), "0", indent);
		this.write(writer, "systemTag", iPSDataEntity.getSystemTag(), "", indent);
		this.write(writer, "tableName", iPSDataEntity.getTableName(), "", indent);
		this.write(writer, "tempDataHolder", iPSDataEntity.getTempDataHolder(), "0", indent);
		//列表数据
		if(iPSDataEntity.getUnionKeyValuePSDEFields() != null){
		}
		this.write(writer, "validLogicValue", iPSDataEntity.getValidLogicValue(), "", indent);
		this.write(writer, "view2Name", iPSDataEntity.getView2Name(), "", indent);
		this.write(writer, "view3Name", iPSDataEntity.getView3Name(), "", indent);
		this.write(writer, "view4Name", iPSDataEntity.getView4Name(), "", indent);
		this.write(writer, "viewName", iPSDataEntity.getViewName(), "", indent);
		this.write(writer, "virtualMode", iPSDataEntity.getVirtualMode(), "0", indent);
		this.write(writer, "enableAPIStorage", iPSDataEntity.isEnableAPIStorage(), "false", indent);
		this.write(writer, "enableCreate", iPSDataEntity.isEnableCreate(), "false", indent);
		this.write(writer, "enableDataVer", iPSDataEntity.isEnableDataVer(), "false", indent);
		this.write(writer, "enableEntityCache", iPSDataEntity.isEnableEntityCache(), "false", indent);
		this.write(writer, "enableModify", iPSDataEntity.isEnableModify(), "false", indent);
		this.write(writer, "enableMultiDS", iPSDataEntity.isEnableMultiDS(), "false", indent);
		this.write(writer, "enableMultiForm", iPSDataEntity.isEnableMultiForm(), "false", indent);
		this.write(writer, "enableMultiStorage", iPSDataEntity.isEnableMultiStorage(), "false", indent);
		this.write(writer, "enableNoSQLStorage", iPSDataEntity.isEnableNoSQLStorage(), "false", indent);
		this.write(writer, "enableRemove", iPSDataEntity.isEnableRemove(), "false", indent);
		this.write(writer, "enableSQLStorage", iPSDataEntity.isEnableSQLStorage(), "false", indent);
		this.write(writer, "enableTempData", iPSDataEntity.isEnableTempData(), "false", indent);
		this.write(writer, "enableTempDataBackend", iPSDataEntity.isEnableTempDataBackend(), "false", indent);
		this.write(writer, "enableTempDataFront", iPSDataEntity.isEnableTempDataFront(), "false", indent);
		this.write(writer, "logicValid", iPSDataEntity.isLogicValid(), "false", indent);
		this.write(writer, "subSysAsCloud", iPSDataEntity.isSubSysAsCloud(), "false", indent);
		this.write(writer, "subSysDE", iPSDataEntity.isSubSysDE(), "false", indent);
		this.write(writer, "virtual", iPSDataEntity.isVirtual(), "false", indent);
		
		net.ibizsys.model.IPSModelSortable iPSModelSortable = (net.ibizsys.model.IPSModelSortable)object;
		
		this.write(writer, "orderValue", iPSModelSortable.getOrderValue(), "99999", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.dataentity.IPSDataEntity iPSDataEntity = (net.ibizsys.model.dataentity.IPSDataEntity)object;
		
		//默认不导出
		if(iPSDataEntity.getAllPSDEActionGroups() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEActionGroups", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.action.DEActionGroupListWriter.class, iPSDataEntity.getAllPSDEActionGroups());
		}
		//默认不导出
		if(iPSDataEntity.getAllPSDEActions() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEActions", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.action.DEActionListWriter.class, iPSDataEntity.getAllPSDEActions());
		}
		//默认不导出
		if(iPSDataEntity.getAllPSDEDBConfigs() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEDBConfigs", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.database.DEDBConfigListWriter.class, iPSDataEntity.getAllPSDEDBConfigs());
		}
		//默认不导出
		if(iPSDataEntity.getAllPSDEDBIndices() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEDBIndices", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.database.DEDBIndexListWriter.class, iPSDataEntity.getAllPSDEDBIndices());
		}
		//默认不导出
		if(iPSDataEntity.getAllPSDEDBTables() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEDBTables", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.database.DEDBTableListWriter.class, iPSDataEntity.getAllPSDEDBTables());
		}
		//默认不导出
		if(iPSDataEntity.getAllPSDEDTSQueues() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEDTSQueues", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.dts.DEDTSQueueListWriter.class, iPSDataEntity.getAllPSDEDTSQueues());
		}
		//默认不导出
		if(iPSDataEntity.getAllPSDEDataExports() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEDataExports", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.dataexport.DEDataExportListWriter.class, iPSDataEntity.getAllPSDEDataExports());
		}
		//默认不导出
		if(iPSDataEntity.getAllPSDEDataImports() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEDataImports", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.dataimport.DEDataImportListWriter.class, iPSDataEntity.getAllPSDEDataImports());
		}
		//默认不导出
		if(iPSDataEntity.getAllPSDEDataQueries() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEDataQueries", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.ds.DEDataQueryListWriter.class, iPSDataEntity.getAllPSDEDataQueries());
		}
		//默认不导出
		if(iPSDataEntity.getAllPSDEDataSets() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEDataSets", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.ds.DEDataSetListWriter.class, iPSDataEntity.getAllPSDEDataSets());
		}
		//默认不导出
		if(iPSDataEntity.getAllPSDEDataSyncs() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEDataSyncs", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.datasync.DEDataSyncListWriter.class, iPSDataEntity.getAllPSDEDataSyncs());
		}
		//默认不导出
		if(iPSDataEntity.getAllPSDEFGroups() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEFGroups", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.defield.DEFGroupListWriter.class, iPSDataEntity.getAllPSDEFGroups());
		}
		//默认不导出
		if(iPSDataEntity.getAllPSDEFields() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEFields", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.ux.dataentity.defield.DEFieldListWriter.class, iPSDataEntity.getAllPSDEFields());
		}
		//默认不导出
		if(iPSDataEntity.getAllPSDEGroups() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEGroups", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.DEGroupListWriter.class, iPSDataEntity.getAllPSDEGroups());
		}
		if(iPSDataEntity.getAllPSDELogics() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDELogics", true)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.DELogicListWriter.class, iPSDataEntity.getAllPSDELogics());
		}
		//默认不导出
		if(iPSDataEntity.getAllPSDEMainStates() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEMainStates", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.mainstate.DEMainStateListWriter.class, iPSDataEntity.getAllPSDEMainStates());
		}
		//默认不导出
		if(iPSDataEntity.getAllPSDEMaps() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEMaps", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.datamap.DEMapListWriter.class, iPSDataEntity.getAllPSDEMaps());
		}
		//默认不导出
		if(iPSDataEntity.getAllPSDEMethodDTOs() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEMethodDTOs", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.service.DEMethodDTOListWriter.class, iPSDataEntity.getAllPSDEMethodDTOs());
		}
		//默认不导出
		if(iPSDataEntity.getAllPSDENotifies() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDENotifies", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.notify.DENotifyListWriter.class, iPSDataEntity.getAllPSDENotifies());
		}
		//默认不导出
		if(iPSDataEntity.getAllPSDEOPPrivs() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEOPPrivs", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.priv.DEOPPrivListWriter.class, iPSDataEntity.getAllPSDEOPPrivs());
		}
		//默认不导出
		if(iPSDataEntity.getAllPSDEPrints() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEPrints", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.print.DEPrintListWriter.class, iPSDataEntity.getAllPSDEPrints());
		}
		//默认不导出
		if(iPSDataEntity.getAllPSDERGroups() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDERGroups", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.der.DERGroupListWriter.class, iPSDataEntity.getAllPSDERGroups());
		}
		//默认不导出
		if(iPSDataEntity.getAllPSDEReports() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEReports", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.report.DEReportListWriter.class, iPSDataEntity.getAllPSDEReports());
		}
		//默认不导出
		if(iPSDataEntity.getAllPSDEUniStates() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEUniStates", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.unistate.DEUniStateListWriter.class, iPSDataEntity.getAllPSDEUniStates());
		}
		//默认不导出
		if(iPSDataEntity.getAllPSDEUserRoles() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEUserRoles", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.priv.DEUserRoleListWriter.class, iPSDataEntity.getAllPSDEUserRoles());
		}
		//默认不导出
		if(iPSDataEntity.getAllPSDEUtils() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEUtils", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.util.DEUtilListWriter.class, iPSDataEntity.getAllPSDEUtils());
		}
		//默认不导出
		if(iPSDataEntity.getAllPSDEWFs() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSDEWFs", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.wf.DEWFListWriter.class, iPSDataEntity.getAllPSDEWFs());
		}
		//默认不导出
		if(iPSDataEntity.getAllPSModelDatas() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getAllPSModelDatas", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.ModelDataListWriter.class, iPSDataEntity.getAllPSModelDatas());
		}
		//列表数据
		if(iPSDataEntity.getMainStatePSDEFields() != null){
		}
		//默认不导出
		if(iPSDataEntity.getMinorPSDERs() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDataEntity.class, "getMinorPSDERs", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.der.DERListWriter.class, iPSDataEntity.getMinorPSDERs());
		}
		//列表数据
		if(iPSDataEntity.getUnionKeyValuePSDEFields() != null){
		}
		
		net.ibizsys.model.IPSModelSortable iPSModelSortable = (net.ibizsys.model.IPSModelSortable)object;
		

		super.onExport(iModelDSLGenEngineContext, object);
	}
}