package net.ibizsys.codegen.template.rtmodel.dsl.dataentity;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class DEGroupWriter extends net.ibizsys.codegen.template.rtmodel.dsl.dataentity.DataEntityObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.dataentity.IPSDEGroup iPSDEGroup = (net.ibizsys.model.dataentity.IPSDEGroup)object;
		
		this.write(writer, "codeName", iPSDEGroup.getCodeName(), "", indent);
		this.write(writer, "codeName2", iPSDEGroup.getCodeName2(), "", indent);
		this.write(writer, "groupTag", iPSDEGroup.getGroupTag(), "", indent);
		this.write(writer, "groupTag2", iPSDEGroup.getGroupTag2(), "", indent);
		this.write(writer, "logicMode", iPSDEGroup.getLogicMode(), "", indent);
		this.write(writer, "logicParam", iPSDEGroup.getLogicParam(), "", indent);
		this.write(writer, "logicParam2", iPSDEGroup.getLogicParam2(), "", indent);
		if(iPSDEGroup.getPSDEGroupDetails() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDEGroup.class, "getPSDEGroupDetails", false)){
			writer.write(indent);
			writer.write("details {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.DEGroupDetailListWriter.class, writer, iPSDEGroup.getPSDEGroupDetails(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "sysSFPlugin", iPSDEGroup.getPSSysSFPlugin(), "", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.dataentity.IPSDEGroup iPSDEGroup = (net.ibizsys.model.dataentity.IPSDEGroup)object;
		
		//默认不导出
		if(iPSDEGroup.getPSDEGroupDetails() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.IPSDEGroup.class, "getPSDEGroupDetails", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.DEGroupDetailListWriter.class, iPSDEGroup.getPSDEGroupDetails());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}