package net.ibizsys.codegen.template.rtmodel.dsl.database;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class SysDBTableWriter extends net.ibizsys.codegen.template.rtmodel.dsl.ModelObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.database.IPSSysDBTable iPSSysDBTable = (net.ibizsys.model.database.IPSSysDBTable)object;
		
		if(iPSSysDBTable.getAllPSSysDBColumns() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.database.IPSSysDBTable.class, "getAllPSSysDBColumns", false)){
			writer.write(indent);
			writer.write("columns {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.database.SysDBColumnListWriter.class, writer, iPSSysDBTable.getAllPSSysDBColumns(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSysDBTable.getAllPSSysDBIndices() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.database.IPSSysDBTable.class, "getAllPSSysDBIndices", false)){
			writer.write(indent);
			writer.write("indices {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.database.SysDBIndexListWriter.class, writer, iPSSysDBTable.getAllPSSysDBIndices(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "codeName", iPSSysDBTable.getCodeName(), "", indent);
		this.write(writer, "createSql", iPSSysDBTable.getCreateSql(), "", indent);
		this.write(writer, "dropSql", iPSSysDBTable.getDropSql(), "", indent);
		this.write(writer, "logicName", iPSSysDBTable.getLogicName(), "", indent);
		this.write(writer, "autoExtendModel", iPSSysDBTable.isAutoExtendModel(), "false", indent);
		this.write(writer, "existingModel", iPSSysDBTable.isExistingModel(), "false", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.database.IPSSysDBTable iPSSysDBTable = (net.ibizsys.model.database.IPSSysDBTable)object;
		
		//默认不导出
		if(iPSSysDBTable.getAllPSSysDBColumns() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.database.IPSSysDBTable.class, "getAllPSSysDBColumns", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.database.SysDBColumnListWriter.class, iPSSysDBTable.getAllPSSysDBColumns());
		}
		//默认不导出
		if(iPSSysDBTable.getAllPSSysDBIndices() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.database.IPSSysDBTable.class, "getAllPSSysDBIndices", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.database.SysDBIndexListWriter.class, iPSSysDBTable.getAllPSSysDBIndices());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}