package net.ibizsys.codegen.template.rtmodel.dsl.database;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class SysDBColumnWriter extends net.ibizsys.codegen.template.rtmodel.dsl.ModelObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.database.IPSSysDBColumn iPSSysDBColumn = (net.ibizsys.model.database.IPSSysDBColumn)object;
		
		this.write(writer, "codeName", iPSSysDBColumn.getCodeName(), "", indent);
		this.write(writer, "codeName2", iPSSysDBColumn.getCodeName2(), "", indent);
		this.write(writer, "createSql", iPSSysDBColumn.getCreateSql(), "", indent);
		this.write(writer, "dataType", iPSSysDBColumn.getDataType(), "", indent);
		this.write(writer, "defaultValue", iPSSysDBColumn.getDefaultValue(), "", indent);
		this.write(writer, "dropSql", iPSSysDBColumn.getDropSql(), "", indent);
		this.write(writer, "length", iPSSysDBColumn.getLength(), "-1", indent);
		this.write(writer, "logicName", iPSSysDBColumn.getLogicName(), "", indent);
		this.write(writer, "precision", iPSSysDBColumn.getPrecision(), "0", indent);
		this.write(writer, "ref", iPSSysDBColumn.getRefPSSysDBColumn(), null, indent);
		this.write(writer, "refSysDBTable", iPSSysDBColumn.getRefPSSysDBTable(), null, indent);
		this.write(writer, "stdDataType", iPSSysDBColumn.getStdDataType(), "0", indent);
		this.write(writer, "autoIncrement", iPSSysDBColumn.isAutoIncrement(), "false", indent);
		this.write(writer, "fkey", iPSSysDBColumn.isFKey(), "false", indent);
		this.write(writer, "nullable", iPSSysDBColumn.isNullable(), "false", indent);
		this.write(writer, "pkey", iPSSysDBColumn.isPKey(), "false", indent);
		this.write(writer, "unsigned", iPSSysDBColumn.isUnsigned(), "false", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.database.IPSSysDBColumn iPSSysDBColumn = (net.ibizsys.model.database.IPSSysDBColumn)object;
		

		super.onExport(iModelDSLGenEngineContext, object);
	}
}