package net.ibizsys.codegen.template.rtmodel.dsl.database;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class DEDBConfigWriter extends net.ibizsys.codegen.template.rtmodel.dsl.dataentity.DataEntityObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.database.IPSDEDBConfig iPSDEDBConfig = (net.ibizsys.model.database.IPSDEDBConfig)object;
		
		this.write(writer, "dbtype", iPSDEDBConfig.getDBType(), "", indent);
		this.write(writer, "objNameCase", iPSDEDBConfig.getObjNameCase(), "", indent);
		this.write(writer, "standardTableName", iPSDEDBConfig.getStandardTableName(), "", indent);
		this.write(writer, "tableName", iPSDEDBConfig.getTableName(), "", indent);
		this.write(writer, "view2Name", iPSDEDBConfig.getView2Name(), "", indent);
		this.write(writer, "view3Name", iPSDEDBConfig.getView3Name(), "", indent);
		this.write(writer, "view4Name", iPSDEDBConfig.getView4Name(), "", indent);
		this.write(writer, "viewName", iPSDEDBConfig.getViewName(), "", indent);
		this.write(writer, "customTableOrView", iPSDEDBConfig.isCustomTableOrView(), "false", indent);
		this.write(writer, "valid", iPSDEDBConfig.isValid(), "false", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.database.IPSDEDBConfig iPSDEDBConfig = (net.ibizsys.model.database.IPSDEDBConfig)object;
		

		super.onExport(iModelDSLGenEngineContext, object);
	}
}