package net.ibizsys.codegen.template.rtmodel.dsl.ba;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class SysBDSchemeWriter extends net.ibizsys.codegen.template.rtmodel.dsl.ModelObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.ba.IPSSysBDScheme iPSSysBDScheme = (net.ibizsys.model.ba.IPSSysBDScheme)object;
		
		if(iPSSysBDScheme.getAllPSSysBDModules() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.ba.IPSSysBDScheme.class, "getAllPSSysBDModules", false)){
			writer.write(indent);
			writer.write("sysBDModules {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.ba.SysBDModuleListWriter.class, writer, iPSSysBDScheme.getAllPSSysBDModules(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSysBDScheme.getAllPSSysBDParts() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.ba.IPSSysBDScheme.class, "getAllPSSysBDParts", false)){
			writer.write(indent);
			writer.write("sysBDParts {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.ba.SysBDPartListWriter.class, writer, iPSSysBDScheme.getAllPSSysBDParts(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSysBDScheme.getAllPSSysBDTables() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.ba.IPSSysBDScheme.class, "getAllPSSysBDTables", false)){
			writer.write(indent);
			writer.write("sysBDTables {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.ba.SysBDTableListWriter.class, writer, iPSSysBDScheme.getAllPSSysBDTables(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "authClientId", iPSSysBDScheme.getAuthClientId(), "", indent);
		this.write(writer, "authClientSecret", iPSSysBDScheme.getAuthClientSecret(), "", indent);
		this.write(writer, "authMode", iPSSysBDScheme.getAuthMode(), "", indent);
		this.write(writer, "authParam", iPSSysBDScheme.getAuthParam(), "", indent);
		this.write(writer, "authParam2", iPSSysBDScheme.getAuthParam2(), "", indent);
		this.write(writer, "sysModelGroup", iPSSysBDScheme.getPSSysModelGroup(), null, indent);
		this.write(writer, "sysSFPlugin", iPSSysBDScheme.getPSSysSFPlugin(), "", indent);
		this.write(writer, "systemModule", iPSSysBDScheme.getPSSystemModule(), null, indent);
		this.write(writer, "serviceParam", iPSSysBDScheme.getServiceParam(), "", indent);
		this.write(writer, "serviceParam2", iPSSysBDScheme.getServiceParam2(), "", indent);
		this.write(writer, "servicePath", iPSSysBDScheme.getServicePath(), "", indent);
		this.write(writer, "defaultMode", iPSSysBDScheme.isDefaultMode(), "false", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.ba.IPSSysBDScheme iPSSysBDScheme = (net.ibizsys.model.ba.IPSSysBDScheme)object;
		
		//默认不导出
		if(iPSSysBDScheme.getAllPSSysBDModules() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.ba.IPSSysBDScheme.class, "getAllPSSysBDModules", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.ba.SysBDModuleListWriter.class, iPSSysBDScheme.getAllPSSysBDModules());
		}
		//默认不导出
		if(iPSSysBDScheme.getAllPSSysBDParts() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.ba.IPSSysBDScheme.class, "getAllPSSysBDParts", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.ba.SysBDPartListWriter.class, iPSSysBDScheme.getAllPSSysBDParts());
		}
		//默认不导出
		if(iPSSysBDScheme.getAllPSSysBDTables() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.ba.IPSSysBDScheme.class, "getAllPSSysBDTables", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.ba.SysBDTableListWriter.class, iPSSysBDScheme.getAllPSSysBDTables());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}