package net.ibizsys.codegen.template.rtmodel.dsl.testing;

import java.io.Writer;
import java.util.List;
import net.ibizsys.codegen.template.rtmodel.dsl.ModelListWriterBase;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class SysTestCaseListWriter extends ModelListWriterBase<net.ibizsys.model.testing.IPSSysTestCase>{
	@Override
	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, List<net.ibizsys.model.testing.IPSSysTestCase> list, String indent) throws Exception {
		for(net.ibizsys.model.testing.IPSSysTestCase item : list) {
			if("APPVIEW".equals(item.getTestCaseType())){
				writer.write(indent);
				writer.write("appview {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.testing.SysTestCase2Writer.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("CUSTOM".equals(item.getTestCaseType())){
				writer.write(indent);
				writer.write("custom {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.testing.SysTestCase2Writer.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("DEACTION".equals(item.getTestCaseType())){
				writer.write(indent);
				writer.write("deaction {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.testing.SysTestCaseWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("DEFVR".equals(item.getTestCaseType())){
				writer.write(indent);
				writer.write("defvr {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.testing.SysTestCaseWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			if("DESADETAIL".equals(item.getTestCaseType())){
				writer.write(indent);
				writer.write("desadetail {\n");
				iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.testing.SysTestCase2Writer.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
				writer.write(indent);
				writer.write("}\n");
				continue;
			}
			
			writer.write(indent);
			writer.write("item {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.testing.SysTestCaseWriter.class, writer, item, indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		//super.onWrite(writer, list, indent);
	}
	
	@Override
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, List<net.ibizsys.model.testing.IPSSysTestCase> list) throws Exception {
		for(net.ibizsys.model.testing.IPSSysTestCase item : list) {
			if("APPVIEW".equals(item.getTestCaseType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.testing.SysTestCase2Writer.class, item, "SysTestCase");
				continue;
			}
			if("CUSTOM".equals(item.getTestCaseType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.testing.SysTestCase2Writer.class, item, "SysTestCase");
				continue;
			}
			if("DEACTION".equals(item.getTestCaseType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.testing.SysTestCaseWriter.class, item, "SysTestCase");
				continue;
			}
			if("DEFVR".equals(item.getTestCaseType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.testing.SysTestCaseWriter.class, item, "SysTestCase");
				continue;
			}
			if("DESADETAIL".equals(item.getTestCaseType())){
				iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.testing.SysTestCase2Writer.class, item, "SysTestCase");
				continue;
			}
			
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.testing.SysTestCaseWriter.class, item, "SysTestCase");
		}
		//super.onExport(root, list);
	}
	
}