package net.ibizsys.codegen.template.rtmodel.dsl.testing;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class SysTestCaseInputWriter extends net.ibizsys.codegen.template.rtmodel.dsl.ModelObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.testing.IPSSysTestCaseInput iPSSysTestCaseInput = (net.ibizsys.model.testing.IPSSysTestCaseInput)object;
		
		this.write(writer, "inputDEAction", iPSSysTestCaseInput.getInputPSDEAction(), null, indent);
		this.write(writer, "inputTag", iPSSysTestCaseInput.getInputTag(), "", indent);
		this.write(writer, "inputTag2", iPSSysTestCaseInput.getInputTag2(), "", indent);
		this.write(writer, "inputTag3", iPSSysTestCaseInput.getInputTag3(), "", indent);
		this.write(writer, "inputTag4", iPSSysTestCaseInput.getInputTag4(), "", indent);
		this.write(writer, "inputType", iPSSysTestCaseInput.getInputType(), "", indent);
		this.write(writer, "inputValue", iPSSysTestCaseInput.getInputValue(), "", indent);
		if(iPSSysTestCaseInput.getPSSysTestCaseAsserts() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.testing.IPSSysTestCaseInput.class, "getPSSysTestCaseAsserts", false)){
			writer.write(indent);
			writer.write("asserts {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.testing.SysTestCaseAssertListWriter.class, writer, iPSSysTestCaseInput.getPSSysTestCaseAsserts(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "sysTestData", iPSSysTestCaseInput.getPSSysTestData(), null, indent);
		this.write(writer, "scriptCode", iPSSysTestCaseInput.getScriptCode(), "", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.testing.IPSSysTestCaseInput iPSSysTestCaseInput = (net.ibizsys.model.testing.IPSSysTestCaseInput)object;
		
		//默认不导出
		if(iPSSysTestCaseInput.getPSSysTestCaseAsserts() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.testing.IPSSysTestCaseInput.class, "getPSSysTestCaseAsserts", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.testing.SysTestCaseAssertListWriter.class, iPSSysTestCaseInput.getPSSysTestCaseAsserts());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}