package net.ibizsys.codegen.template.rtmodel.dsl.service;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class SysServiceAPIWriter extends net.ibizsys.codegen.template.rtmodel.dsl.ModelObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.service.IPSSysServiceAPI iPSSysServiceAPI = (net.ibizsys.model.service.IPSSysServiceAPI)object;
		
		this.write(writer, "apilevel", iPSSysServiceAPI.getAPILevel(), "3", indent);
		this.write(writer, "apimode", iPSSysServiceAPI.getAPIMode(), "0", indent);
		this.write(writer, "apitag", iPSSysServiceAPI.getAPITag(), "", indent);
		this.write(writer, "apitag2", iPSSysServiceAPI.getAPITag2(), "", indent);
		this.write(writer, "apitype", iPSSysServiceAPI.getAPIType(), "", indent);
		this.write(writer, "apiversion", iPSSysServiceAPI.getAPIVersion(), "0", indent);
		this.write(writer, "authCheckTokenUrl", iPSSysServiceAPI.getAuthCheckTokenUrl(), "", indent);
		this.write(writer, "authClientId", iPSSysServiceAPI.getAuthClientId(), "", indent);
		this.write(writer, "authClientSecret", iPSSysServiceAPI.getAuthClientSecret(), "", indent);
		this.write(writer, "authMode", iPSSysServiceAPI.getAuthMode(), "", indent);
		this.write(writer, "authParam", iPSSysServiceAPI.getAuthParam(), "", indent);
		this.write(writer, "authParam2", iPSSysServiceAPI.getAuthParam2(), "", indent);
		this.write(writer, "authParam3", iPSSysServiceAPI.getAuthParam3(), "", indent);
		this.write(writer, "authParam4", iPSSysServiceAPI.getAuthParam4(), "", indent);
		this.write(writer, "codeName", iPSSysServiceAPI.getCodeName(), "", indent);
		this.write(writer, "handler", iPSSysServiceAPI.getHandler(), "", indent);
		this.write(writer, "httpPort", iPSSysServiceAPI.getHttpPort(), "0", indent);
		if(iPSSysServiceAPI.getPSDEServiceAPIRSs() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.service.IPSSysServiceAPI.class, "getPSDEServiceAPIRSs", false)){
			writer.write(indent);
			writer.write("deserviceAPIRSs {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.service.DEServiceAPIRSListWriter.class, writer, iPSSysServiceAPI.getPSDEServiceAPIRSs(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSysServiceAPI.getPSDEServiceAPIs() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.service.IPSSysServiceAPI.class, "getPSDEServiceAPIs", false)){
			writer.write(indent);
			writer.write("deserviceAPIs {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.service.DEServiceAPIListWriter.class, writer, iPSSysServiceAPI.getPSDEServiceAPIs(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "sysSFPlugin", iPSSysServiceAPI.getPSSysSFPlugin(), "", indent);
		this.write(writer, "systemModule", iPSSysServiceAPI.getPSSystemModule(), null, indent);
		this.write(writer, "predefinedType", iPSSysServiceAPI.getPredefinedType(), "", indent);
		this.write(writer, "serviceCodeName", iPSSysServiceAPI.getServiceCodeName(), "", indent);
		this.write(writer, "serviceParam", iPSSysServiceAPI.getServiceParam(), "", indent);
		this.write(writer, "serviceParam2", iPSSysServiceAPI.getServiceParam2(), "", indent);
		this.write(writer, "serviceParam3", iPSSysServiceAPI.getServiceParam3(), "", indent);
		this.write(writer, "serviceParam4", iPSSysServiceAPI.getServiceParam4(), "", indent);
		this.write(writer, "serviceType", iPSSysServiceAPI.getServiceType(), "", indent);
		this.write(writer, "cloudAdminLevel", iPSSysServiceAPI.isCloudAdminLevel(), "false", indent);
		this.write(writer, "coreLevel", iPSSysServiceAPI.isCoreLevel(), "false", indent);
		this.write(writer, "dcadminLevel", iPSSysServiceAPI.isDCAdminLevel(), "false", indent);
		this.write(writer, "enableServiceAPIDTO", iPSSysServiceAPI.isEnableServiceAPIDTO(), "false", indent);
		this.write(writer, "userLevel", iPSSysServiceAPI.isUserLevel(), "false", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.service.IPSSysServiceAPI iPSSysServiceAPI = (net.ibizsys.model.service.IPSSysServiceAPI)object;
		
		//默认不导出
		if(iPSSysServiceAPI.getPSDEServiceAPIRSs() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.service.IPSSysServiceAPI.class, "getPSDEServiceAPIRSs", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.service.DEServiceAPIRSListWriter.class, iPSSysServiceAPI.getPSDEServiceAPIRSs());
		}
		//默认不导出
		if(iPSSysServiceAPI.getPSDEServiceAPIs() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.service.IPSSysServiceAPI.class, "getPSDEServiceAPIs", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.service.DEServiceAPIListWriter.class, iPSSysServiceAPI.getPSDEServiceAPIs());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}