package net.ibizsys.codegen.template.rtmodel.dsl.security;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class SysUserRoleWriter extends net.ibizsys.codegen.template.rtmodel.dsl.ModelObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.security.IPSSysUserRole iPSSysUserRole = (net.ibizsys.model.security.IPSSysUserRole)object;
		
		this.write(writer, "codeName", iPSSysUserRole.getCodeName(), "", indent);
		this.write(writer, "defaultUser", iPSSysUserRole.getDefaultUser(), "NONE", indent);
		this.write(writer, "dedataSet", iPSSysUserRole.getPSDEDataSet(), null, indent);
		this.write(writer, "dataEntity", iPSSysUserRole.getPSDataEntity(), null, indent);
		if(iPSSysUserRole.getPSSysUserRoleDatas() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.security.IPSSysUserRole.class, "getPSSysUserRoleDatas", false)){
			writer.write(indent);
			writer.write("datas {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.security.SysUserRoleDataListWriter.class, writer, iPSSysUserRole.getPSSysUserRoleDatas(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSysUserRole.getPSSysUserRoleReses() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.security.IPSSysUserRole.class, "getPSSysUserRoleReses", false)){
			writer.write(indent);
			writer.write("reses {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.security.SysUserRoleResListWriter.class, writer, iPSSysUserRole.getPSSysUserRoleReses(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "systemModule", iPSSysUserRole.getPSSystemModule(), null, indent);
		this.write(writer, "roleTag", iPSSysUserRole.getRoleTag(), "", indent);
		this.write(writer, "roleType", iPSSysUserRole.getRoleType(), "", indent);
		this.write(writer, "globalRole", iPSSysUserRole.isGlobalRole(), "false", indent);
		this.write(writer, "systemReserved", iPSSysUserRole.isSystemReserved(), "false", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.security.IPSSysUserRole iPSSysUserRole = (net.ibizsys.model.security.IPSSysUserRole)object;
		
		//默认不导出
		if(iPSSysUserRole.getPSSysUserRoleDatas() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.security.IPSSysUserRole.class, "getPSSysUserRoleDatas", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.security.SysUserRoleDataListWriter.class, iPSSysUserRole.getPSSysUserRoleDatas());
		}
		//默认不导出
		if(iPSSysUserRole.getPSSysUserRoleReses() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.security.IPSSysUserRole.class, "getPSSysUserRoleReses", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.security.SysUserRoleResListWriter.class, iPSSysUserRole.getPSSysUserRoleReses());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}