package net.ibizsys.codegen.template.rtmodel.dsl.dataentity.wizard;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class DEWizardWriter extends net.ibizsys.codegen.template.rtmodel.dsl.dataentity.DataEntityObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.dataentity.wizard.IPSDEWizard iPSDEWizard = (net.ibizsys.model.dataentity.wizard.IPSDEWizard)object;
		
		this.write(writer, "codeName", iPSDEWizard.getCodeName(), "", indent);
		this.write(writer, "finishCapLanResTag", iPSDEWizard.getFinishCapLanResTag(), "", indent);
		this.write(writer, "finishCapLanguageRes", iPSDEWizard.getFinishCapPSLanguageRes(), "", indent);
		this.write(writer, "finishCaption", iPSDEWizard.getFinishCaption(), "", indent);
		this.write(writer, "firstForm", iPSDEWizard.getFirstPSDEWizardForm(), null, indent);
		this.write(writer, "nextCapLanResTag", iPSDEWizard.getNextCapLanResTag(), "", indent);
		this.write(writer, "nextCapLanguageRes", iPSDEWizard.getNextCapPSLanguageRes(), "", indent);
		this.write(writer, "nextCaption", iPSDEWizard.getNextCaption(), "", indent);
		if(iPSDEWizard.getPSDEWizardForms() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.wizard.IPSDEWizard.class, "getPSDEWizardForms", false)){
			writer.write(indent);
			writer.write("forms {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.wizard.DEWizardFormListWriter.class, writer, iPSDEWizard.getPSDEWizardForms(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDEWizard.getPSDEWizardSteps() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.wizard.IPSDEWizard.class, "getPSDEWizardSteps", false)){
			writer.write(indent);
			writer.write("steps {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.wizard.DEWizardStepListWriter.class, writer, iPSDEWizard.getPSDEWizardSteps(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "prevCapLanResTag", iPSDEWizard.getPrevCapLanResTag(), "", indent);
		this.write(writer, "prevCapLanguageRes", iPSDEWizard.getPrevCapPSLanguageRes(), "", indent);
		this.write(writer, "prevCaption", iPSDEWizard.getPrevCaption(), "", indent);
		this.write(writer, "wizardStyle", iPSDEWizard.getWizardStyle(), "", indent);
		this.write(writer, "enableMainStateLogic", iPSDEWizard.isEnableMainStateLogic(), "false", indent);
		this.write(writer, "stateWizard", iPSDEWizard.isStateWizard(), "false", indent);
		
		net.ibizsys.model.IPSModelSortable iPSModelSortable = (net.ibizsys.model.IPSModelSortable)object;
		
		this.write(writer, "orderValue", iPSModelSortable.getOrderValue(), "0", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.dataentity.wizard.IPSDEWizard iPSDEWizard = (net.ibizsys.model.dataentity.wizard.IPSDEWizard)object;
		
		//默认不导出
		if(iPSDEWizard.getPSDEWizardForms() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.wizard.IPSDEWizard.class, "getPSDEWizardForms", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.wizard.DEWizardFormListWriter.class, iPSDEWizard.getPSDEWizardForms());
		}
		//默认不导出
		if(iPSDEWizard.getPSDEWizardSteps() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.wizard.IPSDEWizard.class, "getPSDEWizardSteps", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.wizard.DEWizardStepListWriter.class, iPSDEWizard.getPSDEWizardSteps());
		}
		
		net.ibizsys.model.IPSModelSortable iPSModelSortable = (net.ibizsys.model.IPSModelSortable)object;
		

		super.onExport(iModelDSLGenEngineContext, object);
	}
}