package net.ibizsys.codegen.template.rtmodel.dsl.dataentity.service;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class DEServiceAPIWriter extends net.ibizsys.codegen.template.rtmodel.dsl.dataentity.DataEntityObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.dataentity.service.IPSDEServiceAPI iPSDEServiceAPI = (net.ibizsys.model.dataentity.service.IPSDEServiceAPI)object;
		
		this.write(writer, "apimode", iPSDEServiceAPI.getAPIMode(), "0", indent);
		this.write(writer, "codeName", iPSDEServiceAPI.getCodeName(), "", indent);
		this.write(writer, "codeName2", iPSDEServiceAPI.getCodeName2(), "", indent);
		this.write(writer, "lnlanguageRes", iPSDEServiceAPI.getLNPSLanguageRes(), "", indent);
		this.write(writer, "logicName", iPSDEServiceAPI.getLogicName(), "", indent);
		if(iPSDEServiceAPI.getMinorPSDEServiceAPIRSs() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.service.IPSDEServiceAPI.class, "getMinorPSDEServiceAPIRSs", false)){
			writer.write(indent);
			writer.write("minorRSs {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.service.DEServiceAPIRSListWriter.class, writer, iPSDEServiceAPI.getMinorPSDEServiceAPIRSs(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDEServiceAPI.getPSDEServiceAPIFields() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.service.IPSDEServiceAPI.class, "getPSDEServiceAPIFields", false)){
			writer.write(indent);
			writer.write("fields {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.service.DEServiceAPIFieldListWriter.class, writer, iPSDEServiceAPI.getPSDEServiceAPIFields(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDEServiceAPI.getPSDEServiceAPIMethods() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.service.IPSDEServiceAPI.class, "getPSDEServiceAPIMethods", false)){
			writer.write(indent);
			writer.write("methods {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.service.DEServiceAPIMethodListWriter.class, writer, iPSDEServiceAPI.getPSDEServiceAPIMethods(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "dataEntity", iPSDEServiceAPI.getPSDataEntity(), null, indent);
		this.write(writer, "sysSFPlugin", iPSDEServiceAPI.getPSSysSFPlugin(), "", indent);
		this.write(writer, "enableDataExport", iPSDEServiceAPI.isEnableDataExport(), "false", indent);
		this.write(writer, "enableDataImport", iPSDEServiceAPI.isEnableDataImport(), "false", indent);
		this.write(writer, "major", iPSDEServiceAPI.isMajor(), "false", indent);
		this.write(writer, "nested", iPSDEServiceAPI.isNested(), "false", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.dataentity.service.IPSDEServiceAPI iPSDEServiceAPI = (net.ibizsys.model.dataentity.service.IPSDEServiceAPI)object;
		
		//默认不导出
		if(iPSDEServiceAPI.getMinorPSDEServiceAPIRSs() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.service.IPSDEServiceAPI.class, "getMinorPSDEServiceAPIRSs", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.service.DEServiceAPIRSListWriter.class, iPSDEServiceAPI.getMinorPSDEServiceAPIRSs());
		}
		//默认不导出
		if(iPSDEServiceAPI.getPSDEServiceAPIFields() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.service.IPSDEServiceAPI.class, "getPSDEServiceAPIFields", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.service.DEServiceAPIFieldListWriter.class, iPSDEServiceAPI.getPSDEServiceAPIFields());
		}
		//默认不导出
		if(iPSDEServiceAPI.getPSDEServiceAPIMethods() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.service.IPSDEServiceAPI.class, "getPSDEServiceAPIMethods", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.service.DEServiceAPIMethodListWriter.class, iPSDEServiceAPI.getPSDEServiceAPIMethods());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}