package net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class DELogicNodeWriter extends net.ibizsys.codegen.template.rtmodel.dsl.ModelObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.dataentity.logic.IPSDELogicNode iPSDELogicNode = (net.ibizsys.model.dataentity.logic.IPSDELogicNode)object;
		
		this.write(writer, "codeName", iPSDELogicNode.getCodeName(), "", indent);
		this.write(writer, "height", iPSDELogicNode.getHeight(), "0", indent);
		this.write(writer, "leftPos", iPSDELogicNode.getLeftPos(), "0", indent);
		this.write(writer, "logicNodeType", iPSDELogicNode.getLogicNodeType(), "", indent);
		if(iPSDELogicNode.getPSDELogicLinks() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.logic.IPSDELogicNode.class, "getPSDELogicLinks", false)){
			writer.write(indent);
			writer.write("links {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.DELogicLinkListWriter.class, writer, iPSDELogicNode.getPSDELogicLinks(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDELogicNode.getPSDELogicNodeParams() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.logic.IPSDELogicNode.class, "getPSDELogicNodeParams", false)){
			writer.write(indent);
			writer.write("params {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.DELogicNodeParamListWriter.class, writer, iPSDELogicNode.getPSDELogicNodeParams(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "sysSFPlugin", iPSDELogicNode.getPSSysSFPlugin(), "", indent);
		this.write(writer, "topPos", iPSDELogicNode.getTopPos(), "0", indent);
		this.write(writer, "width", iPSDELogicNode.getWidth(), "0", indent);
		this.write(writer, "parallelOutput", iPSDELogicNode.isParallelOutput(), "false", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.dataentity.logic.IPSDELogicNode iPSDELogicNode = (net.ibizsys.model.dataentity.logic.IPSDELogicNode)object;
		
		//默认不导出
		if(iPSDELogicNode.getPSDELogicLinks() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.logic.IPSDELogicNode.class, "getPSDELogicLinks", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.DELogicLinkListWriter.class, iPSDELogicNode.getPSDELogicLinks());
		}
		//默认不导出
		if(iPSDELogicNode.getPSDELogicNodeParams() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.logic.IPSDELogicNode.class, "getPSDELogicNodeParams", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.DELogicNodeParamListWriter.class, iPSDELogicNode.getPSDELogicNodeParams());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}