package net.ibizsys.codegen.template.rtmodel.dsl.dataentity.dataexport;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class DEDataExportWriter extends net.ibizsys.codegen.template.rtmodel.dsl.dataentity.DataEntityObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.dataentity.dataexport.IPSDEDataExport iPSDEDataExport = (net.ibizsys.model.dataentity.dataexport.IPSDEDataExport)object;
		
		this.write(writer, "codeName", iPSDEDataExport.getCodeName(), "", indent);
		this.write(writer, "groupLevel", iPSDEDataExport.getGroupLevel(), "0", indent);
		this.write(writer, "maxRowCount", iPSDEDataExport.getMaxRowCount(), "0", indent);
		this.write(writer, "potime", iPSDEDataExport.getPOTime(), "-1", indent);
		if(iPSDEDataExport.getPSDEDataExportGroups() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.dataexport.IPSDEDataExport.class, "getPSDEDataExportGroups", false)){
			writer.write(indent);
			writer.write("groups {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.dataexport.DEDataExportGroupListWriter.class, writer, iPSDEDataExport.getPSDEDataExportGroups(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSDEDataExport.getPSDEDataExportItems() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.dataexport.IPSDEDataExport.class, "getPSDEDataExportItems", false)){
			writer.write(indent);
			writer.write("items {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.dataexport.DEDataExportItemListWriter.class, writer, iPSDEDataExport.getPSDEDataExportItems(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		this.write(writer, "sysPFPlugin", iPSDEDataExport.getPSSysPFPlugin(), "", indent);
		this.write(writer, "sysSFPlugin", iPSDEDataExport.getPSSysSFPlugin(), "", indent);
		this.write(writer, "defaultMode", iPSDEDataExport.isDefaultMode(), "false", indent);
		this.write(writer, "enableBackend", iPSDEDataExport.isEnableBackend(), "false", indent);
		
		net.ibizsys.model.IPSModelSortable iPSModelSortable = (net.ibizsys.model.IPSModelSortable)object;
		
		this.write(writer, "orderValue", iPSModelSortable.getOrderValue(), "0", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.dataentity.dataexport.IPSDEDataExport iPSDEDataExport = (net.ibizsys.model.dataentity.dataexport.IPSDEDataExport)object;
		
		//默认不导出
		if(iPSDEDataExport.getPSDEDataExportGroups() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.dataexport.IPSDEDataExport.class, "getPSDEDataExportGroups", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.dataexport.DEDataExportGroupListWriter.class, iPSDEDataExport.getPSDEDataExportGroups());
		}
		//默认不导出
		if(iPSDEDataExport.getPSDEDataExportItems() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.dataexport.IPSDEDataExport.class, "getPSDEDataExportItems", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.dataexport.DEDataExportItemListWriter.class, iPSDEDataExport.getPSDEDataExportItems());
		}
		
		net.ibizsys.model.IPSModelSortable iPSModelSortable = (net.ibizsys.model.IPSModelSortable)object;
		

		super.onExport(iModelDSLGenEngineContext, object);
	}
}