package net.ibizsys.codegen.template.rtmodel.dsl.codelist;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class CodeListWriter extends net.ibizsys.codegen.template.rtmodel.dsl.codelist.CodeItemWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.codelist.IPSCodeList iPSCodeList = (net.ibizsys.model.codelist.IPSCodeList)object;
		
		this.write(writer, "beginValueDEField", iPSCodeList.getBeginValuePSDEField(), null, indent);
		this.write(writer, "cacheTimeout", iPSCodeList.getCacheTimeout(), "-1", indent);
		this.write(writer, "codeListTag", iPSCodeList.getCodeListTag(), "", indent);
		this.write(writer, "codeListType", iPSCodeList.getCodeListType(), "", indent);
		this.write(writer, "codeName", iPSCodeList.getCodeName(), "", indent);
		this.write(writer, "customCond", iPSCodeList.getCustomCond(), "", indent);
		this.write(writer, "dataDEField", iPSCodeList.getDataPSDEField(), null, indent);
		this.write(writer, "disableDEField", iPSCodeList.getDisablePSDEField(), null, indent);
		this.write(writer, "emptyText", iPSCodeList.getEmptyText(), "", indent);
		this.write(writer, "emptyTextLanguageRes", iPSCodeList.getEmptyTextPSLanguageRes(), "", indent);
		this.write(writer, "endValueDEField", iPSCodeList.getEndValuePSDEField(), null, indent);
		this.write(writer, "iconClsDEField", iPSCodeList.getIconClsPSDEField(), null, indent);
		this.write(writer, "iconClsXDEField", iPSCodeList.getIconClsXPSDEField(), null, indent);
		this.write(writer, "iconPathXDEField", iPSCodeList.getIconPathXPSDEField(), null, indent);
		this.write(writer, "incBeginValueMode", iPSCodeList.getIncBeginValueMode(), "0", indent);
		this.write(writer, "incEndValueMode", iPSCodeList.getIncEndValueMode(), "0", indent);
		this.write(writer, "minorSortDir", iPSCodeList.getMinorSortDir(), "", indent);
		this.write(writer, "minorSortDEField", iPSCodeList.getMinorSortPSDEField(), null, indent);
		this.write(writer, "orMode", iPSCodeList.getOrMode(), "", indent);
		this.write(writer, "templId", iPSCodeList.getPSCodeListTemplId(), "", indent);
		this.write(writer, "dedataSet", iPSCodeList.getPSDEDataSet(), null, indent);
		this.write(writer, "dataEntity", iPSCodeList.getPSDataEntity(), null, indent);
		this.write(writer, "sysPFPlugin", iPSCodeList.getPSSysPFPlugin(), "", indent);
		this.write(writer, "sysSFPlugin", iPSCodeList.getPSSysSFPlugin(), "", indent);
		this.write(writer, "systemModule", iPSCodeList.getPSSystemModule(), null, indent);
		this.write(writer, "pvalueDEField", iPSCodeList.getPValuePSDEField(), null, indent);
		this.write(writer, "predefinedType", iPSCodeList.getPredefinedType(), "", indent);
		this.write(writer, "refFlag", iPSCodeList.getRefFlag(), "false", indent);
		this.write(writer, "systemTag", iPSCodeList.getSystemTag(), "", indent);
		this.write(writer, "textDEField", iPSCodeList.getTextPSDEField(), null, indent);
		this.write(writer, "textSeparator", iPSCodeList.getTextSeparator(), "", indent);
		this.write(writer, "valueDEField", iPSCodeList.getValuePSDEField(), null, indent);
		this.write(writer, "valueSeparator", iPSCodeList.getValueSeparator(), "", indent);
		this.write(writer, "codeItemValueNumber", iPSCodeList.isCodeItemValueNumber(), "false", indent);
		this.write(writer, "enableCache", iPSCodeList.isEnableCache(), "false", indent);
		this.write(writer, "moduleInstCodeList", iPSCodeList.isModuleInstCodeList(), "false", indent);
		this.write(writer, "subSysAsCloud", iPSCodeList.isSubSysAsCloud(), "false", indent);
		this.write(writer, "subSysCodeList", iPSCodeList.isSubSysCodeList(), "false", indent);
		this.write(writer, "thresholdGroup", iPSCodeList.isThresholdGroup(), "false", indent);
		this.write(writer, "userScope", iPSCodeList.isUserScope(), "false", indent);

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.codelist.IPSCodeList iPSCodeList = (net.ibizsys.model.codelist.IPSCodeList)object;
		

		super.onExport(iModelDSLGenEngineContext, object);
	}
}