package net.ibizsys.codegen.template.rtmodel.dsl.bi;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class SysBICubeWriter extends net.ibizsys.codegen.template.rtmodel.dsl.bi.SysBISchemeObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.bi.IPSSysBICube iPSSysBICube = (net.ibizsys.model.bi.IPSSysBICube)object;
		
		if(iPSSysBICube.getAllPSSysBICubeDimensions() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.bi.IPSSysBICube.class, "getAllPSSysBICubeDimensions", false)){
			writer.write(indent);
			writer.write("dimensions {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.bi.SysBICubeDimensionListWriter.class, writer, iPSSysBICube.getAllPSSysBICubeDimensions(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSysBICube.getAllPSSysBICubeMeasures() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.bi.IPSSysBICube.class, "getAllPSSysBICubeMeasures", false)){
			writer.write(indent);
			writer.write("measures {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.bi.SysBICubeMeasureListWriter.class, writer, iPSSysBICube.getAllPSSysBICubeMeasures(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.bi.IPSSysBICube iPSSysBICube = (net.ibizsys.model.bi.IPSSysBICube)object;
		
		//默认不导出
		if(iPSSysBICube.getAllPSSysBICubeDimensions() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.bi.IPSSysBICube.class, "getAllPSSysBICubeDimensions", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.bi.SysBICubeDimensionListWriter.class, iPSSysBICube.getAllPSSysBICubeDimensions());
		}
		//默认不导出
		if(iPSSysBICube.getAllPSSysBICubeMeasures() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.bi.IPSSysBICube.class, "getAllPSSysBICubeMeasures", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.bi.SysBICubeMeasureListWriter.class, iPSSysBICube.getAllPSSysBICubeMeasures());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}