package net.ibizsys.codegen.template.rtmodel.dsl.ba;

import java.io.File;
import java.io.Writer;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class SysBDTableWriter extends net.ibizsys.codegen.template.rtmodel.dsl.ba.SysBDSchemeObjectWriter{

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception{
		
		net.ibizsys.model.ba.IPSSysBDTable iPSSysBDTable = (net.ibizsys.model.ba.IPSSysBDTable)object;
		
		if(iPSSysBDTable.getAllPSSysBDColSets() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.ba.IPSSysBDTable.class, "getAllPSSysBDColSets", false)){
			writer.write(indent);
			writer.write("sysBDColSets {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.ba.SysBDColSetListWriter.class, writer, iPSSysBDTable.getAllPSSysBDColSets(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSysBDTable.getAllPSSysBDColumns() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.ba.IPSSysBDTable.class, "getAllPSSysBDColumns", false)){
			writer.write(indent);
			writer.write("sysBDColumns {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.ba.SysBDColumnListWriter.class, writer, iPSSysBDTable.getAllPSSysBDColumns(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}
		if(iPSSysBDTable.getMinorPSSysBDTableRSs() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.ba.IPSSysBDTable.class, "getMinorPSSysBDTableRSs", false)){
			writer.write(indent);
			writer.write("minorRSs {\n");
			iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.ba.SysBDTableRSListWriter.class, writer, iPSSysBDTable.getMinorPSSysBDTableRSs(), indent + iModelDSLGenEngineContext.getIndent());
			writer.write(indent);
			writer.write("}\n");
		}

		super.onWrite(iModelDSLGenEngineContext, writer, object, indent);
	}
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject object) throws Exception{
		
		net.ibizsys.model.ba.IPSSysBDTable iPSSysBDTable = (net.ibizsys.model.ba.IPSSysBDTable)object;
		
		//默认不导出
		if(iPSSysBDTable.getAllPSSysBDColSets() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.ba.IPSSysBDTable.class, "getAllPSSysBDColSets", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.ba.SysBDColSetListWriter.class, iPSSysBDTable.getAllPSSysBDColSets());
		}
		//默认不导出
		if(iPSSysBDTable.getAllPSSysBDColumns() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.ba.IPSSysBDTable.class, "getAllPSSysBDColumns", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.ba.SysBDColumnListWriter.class, iPSSysBDTable.getAllPSSysBDColumns());
		}
		//默认不导出
		if(iPSSysBDTable.getMinorPSSysBDTableRSs() != null && iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.ba.IPSSysBDTable.class, "getMinorPSSysBDTableRSs", false)){
			iModelDSLGenEngineContext.export(net.ibizsys.codegen.template.rtmodel.dsl.ba.SysBDTableRSListWriter.class, iPSSysBDTable.getMinorPSSysBDTableRSs());
		}

		super.onExport(iModelDSLGenEngineContext, object);
	}
}