package net.ibizsys.codegen.template.rtmodel.dsl;

import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

import org.springframework.util.StringUtils;

import net.ibizsys.model.IPSModelObject;

public abstract class ModelWriterBase implements IModelWriter {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(ModelWriterBase.class);
	
	private static ThreadLocal<Map> KeyMapThreadLocal = new ThreadLocal<Map>();
	
	@Override
	public void write(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject iPSModelObject, String indent) throws Exception {
		Map last = KeyMapThreadLocal.get();
		try {
			Map<String, Object> keyMap = new HashMap<String, Object>();
			KeyMapThreadLocal.set(keyMap);
			this.onWrite(iModelDSLGenEngineContext, writer, iPSModelObject, indent);
		}
		finally {
			KeyMapThreadLocal.set(last);
		}
	}

	protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject iPSModelObject, String indent) throws Exception{
		
	}
	
	@Override
	public void export(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject iPSModelObject) throws Exception {
		onExport(iModelDSLGenEngineContext, iPSModelObject);
	}
	
	protected void onExport(IModelDSLGenEngineContext iModelDSLGenEngineContext, IPSModelObject iPSModelObject) throws Exception {
		
	}
	
	protected void write(Writer writer, String key, Object value, String defaultValue, String indent) throws Exception{
		
		Map map = KeyMapThreadLocal.get();
		
		if(value == null || map.containsKey(key)) {
			return;
		}

		map.put(key, value);
		
		if(value instanceof IPSModelObject) {
			IPSModelObject iPSModelObject = (IPSModelObject)value;
			String strId = net.ibizsys.model.PSModelUtils.calcUniqueTag(iPSModelObject);
			if(StringUtils.hasLength(strId)) {
				writer.append(indent);
				writer.append(key);
				writer.append(" ");
				writer.append(String.format("'%1$s'", strId));
				writer.append("\n");
			}
			return;
		}
		
		String strValue = value.toString();
		if(defaultValue.equals(strValue)) {
			return;
		}
		writer.append(indent);
		writer.append(key);
		writer.append(" ");
		if(value instanceof String) {
			//需要判断是否多行
			if(strValue.indexOf("\n") != -1 || strValue.indexOf("\r") != -1) {
				writer.append(String.format("'''%1$s'''", strValue.replace("\\", "\\\\").replace("'", "\\'")));
			}
			else {
				writer.append(String.format("'%1$s'", strValue.replace("\\", "\\\\").replace("'", "\\'")));
			}
			
			
			writer.append("\n");
			return;
		} else if (value instanceof java.math.BigInteger) {
			writer.append(String.format("new BigInteger('%1$s')", value.toString()));
			writer.append("\n");
			return;
		} else if (value instanceof java.math.BigDecimal) {
			writer.append(String.format("new BigDecimal('%1$s')", value.toString()));
			writer.append("\n");
			return;
		} else if (value instanceof java.lang.Double) {
			writer.append(String.format("%1$sd", value.toString()));
			writer.append("\n");
			return;
		}

		
		writer.append(value.toString());
		writer.append("\n");
	}
	
	
}
