package net.ibizsys.codegen.template.rtmodel.dsl;

import java.io.File;
import java.util.List;

import net.ibizsys.model.IPSModelObject;

public interface IModelDSLGenEngineContext {

	String getIndent();
	
	
	void write(Class<?> writerCls, java.io.Writer writer, List list, String indent) throws Exception;

	
	void write(Class<?> writerCls, java.io.Writer writer, IPSModelObject iPSModelObject, String indent) throws Exception;
	

	/**
	 * 导出指定模型到指定根目录
	 * @param writerCls
	 * @param root
	 * @param list
	 * @throws Exception
	 */
	void export(Class<?> writerCls, List list) throws Exception;
	
	/**
	 * 导出指定模型到指定根目录
	 * @param writerCls
	 * @param root
	 * @param iPSModelObject
	 * @param defaultType
	 * @throws Exception
	 */
	void export(Class<?> writerCls, IPSModelObject iPSModelObject, String defaultType) throws Exception;
	
	
	/**
	 * 判断传入模型指定属性是否导出为文件
	 * @param modelCls
	 * @param modelProperty
	 * @param def
	 * @return
	 */
	boolean isExportModelFile(Class<?> modelCls, String modelProperty, boolean def);
}
