package net.ibizsys.codegen.template.rtmodel.dsl;

import net.ibizsys.codegen.template.rtmodel.dsl.codelist.CodeListWriter;
import net.ibizsys.codegen.template.rtmodel.dsl.dataentity.DataEntityWriter;
import net.ibizsys.codegen.template.rtmodel.dsl.dataentity.dataexport.DEDataExportWriter;
import net.ibizsys.codegen.template.rtmodel.dsl.dataentity.dataimport.DEDataImportWriter;
import net.ibizsys.codegen.template.rtmodel.dsl.dataentity.defield.valuerule.DEFValueRuleWriter;
import net.ibizsys.codegen.template.rtmodel.dsl.dataentity.logic.DELogicWriter;
import net.ibizsys.codegen.template.rtmodel.dsl.dataentity.mainstate.DEMainStateWriter;
import net.ibizsys.codegen.template.rtmodel.dsl.dataentity.print.DEPrintWriter;
import net.ibizsys.codegen.template.rtmodel.dsl.dataentity.report.DEReportWriter;
import net.ibizsys.codegen.template.rtmodel.dsl.valuerule.SysValueRuleWriter;
import net.ibizsys.model.IPSSystem;
import net.ibizsys.model.codelist.IPSCodeList;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.dataexport.IPSDEDataExport;
import net.ibizsys.model.dataentity.dataimport.IPSDEDataImport;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.defield.valuerule.IPSDEFValueRule;
import net.ibizsys.model.dataentity.logic.IPSDELogic;
import net.ibizsys.model.dataentity.mainstate.IPSDEMainState;
import net.ibizsys.model.dataentity.print.IPSDEPrint;
import net.ibizsys.model.dataentity.report.IPSDEReport;
import net.ibizsys.model.valuerule.IPSSysValueRule;
import org.springframework.util.CollectionUtils;

import java.io.File;

public class GroovyDSLGenHelper {

    private static GroovyDSLGenEngine groovyDSLGenEngine = null;

    private static GroovyDSLGenEngine groovyDSLGenEngine2 = null;

    public static void export2(IPSSystem iPSSystem, String path, String basePackage) throws Exception {
        if (groovyDSLGenEngine2 == null) {
            groovyDSLGenEngine2 = new GroovyDSLGenEngine(new File(path), basePackage);
        }

        groovyDSLGenEngine2.export(iPSSystem);
    }

    public static void export(IPSSystem iPSSystem, String path, String basePackage) throws Exception {
        if (groovyDSLGenEngine == null) {
            groovyDSLGenEngine = new GroovyDSLGenEngine(new File(path), basePackage);
        }

        // export 系统
        groovyDSLGenEngine.export(SystemWriter.class, iPSSystem, null);

        // export 系统值规则
        if (iPSSystem.getAllPSSysValueRules() != null) {
            for (IPSSysValueRule iPSSysValueRule : iPSSystem.getAllPSSysValueRules()) {
                groovyDSLGenEngine.export(SysValueRuleWriter.class, iPSSysValueRule, "valuerule");
            }
        }

        // export 代码表
        if (iPSSystem.getAllPSCodeLists() != null) {
            for (IPSCodeList iPSCodeList : iPSSystem.getAllPSCodeLists()) {
                groovyDSLGenEngine.export(CodeListWriter.class, iPSCodeList, "");
            }
        }

        // export 实体
        if (iPSSystem.getAllPSDataEntities() != null) {
            for (IPSDataEntity iPSDataEntity : iPSSystem.getAllPSDataEntities()) {
                groovyDSLGenEngine.export(DataEntityWriter.class, iPSDataEntity, "");

                if (iPSDataEntity.getAllPSDEFields() != null) {
                    for (IPSDEField iPSDEField : iPSDataEntity.getAllPSDEFields()) {
                        if (iPSDataEntity.getAllPSDEFields() != null) {
                            // export 属性值规则
                            for (IPSDEFValueRule iPSDEFValueRule : iPSDEField.getAllPSDEFValueRules()) {
                                if(!iPSDEFValueRule.isEnableBackend() || iPSDEFValueRule.getPSDEFVRGroupCondition()==null)
                                    continue;
                                if(CollectionUtils.isEmpty(iPSDEFValueRule.getPSDEFVRGroupCondition().getPSDEFVRConditions()))
                                    continue;
                                groovyDSLGenEngine.export(DEFValueRuleWriter.class, iPSDEFValueRule, "");
                            }
                        }
                    }
                }

                if (iPSDataEntity.getAllPSDELogics() != null) {
                    for (IPSDELogic iPSDELogic : iPSDataEntity.getAllPSDELogics()) {
                        if (!iPSDELogic.isEnableBackend())
                            continue;
                        // export 实体处理逻辑
                        groovyDSLGenEngine.export(DELogicWriter.class, iPSDELogic, "");
                    }
                }

                if (iPSDataEntity.getAllPSDEMainStates() != null) {
                    for (IPSDEMainState iPSDEMainState : iPSDataEntity.getAllPSDEMainStates()) {
                        // export 实体主状态控制
                        groovyDSLGenEngine.export(DEMainStateWriter.class, iPSDEMainState, "");
                    }
                }

                if (iPSDataEntity.getAllPSDEDataImports() != null) {
                    for (IPSDEDataImport iPSDEDataImport : iPSDataEntity.getAllPSDEDataImports()) {
                        // export 实体导入
                        groovyDSLGenEngine.export(DEDataImportWriter.class, iPSDEDataImport, "");
                    }
                }


                if (iPSDataEntity.getAllPSDEDataExports() != null) {
                    for (IPSDEDataExport iPSDEDataExport : iPSDataEntity.getAllPSDEDataExports()) {
                        // export 实体导出
                        groovyDSLGenEngine.export(DEDataExportWriter.class, iPSDEDataExport, "");
                    }
                }


                if (iPSDataEntity.getAllPSDEPrints() != null) {
                    for (IPSDEPrint iPSDEPrint : iPSDataEntity.getAllPSDEPrints()) {
                        // export 实体打印
                        groovyDSLGenEngine.export(DEPrintWriter.class, iPSDEPrint, "");
                    }
                }

                if (iPSDataEntity.getAllPSDEReports() != null) {
                    for (IPSDEReport iPSDEReport : iPSDataEntity.getAllPSDEReports()) {
                        // export 实体报表
                        groovyDSLGenEngine.export(DEReportWriter.class, iPSDEReport, "");
                    }
                }
            }
        }






    }

}
