/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.codegen.template.rtmodel.dsl;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelListWriter;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelWriter;
import net.ibizsys.codegen.template.rtmodel.dsl.ModelDSLGenEngine;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.codelist.IPSCodeList;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.dataexport.IPSDEDataExport;
import net.ibizsys.model.dataentity.dataimport.IPSDEDataImport;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.defield.valuerule.IPSDEFValueRule;
import net.ibizsys.model.dataentity.logic.IPSDELogic;
import net.ibizsys.model.dataentity.mainstate.IPSDEMainState;
import net.ibizsys.model.dataentity.print.IPSDEPrint;
import net.ibizsys.model.dataentity.report.IPSDEReport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class GroovyDSLGenEngine
extends ModelDSLGenEngine {
    private static final Log log = LogFactory.getLog(GroovyDSLGenEngine.class);
    private String basePackage = null;
    private Map<Class<?>, IModelWriter> modelWriterMap = new HashMap();
    private Map<Class<?>, IModelListWriter<?>> modelListWriterMap = new HashMap();

    public GroovyDSLGenEngine(File rootFolder, String basePackage) {
        super(rootFolder);
        this.basePackage = basePackage;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public void export(Class<?> writerCls, IPSModelObject iPSModelObject, String defaultType) throws Exception {
        IModelWriter iModelWriter = this.getModelWriter(writerCls);
        String modelFile = this.getFileName(iPSModelObject, defaultType);
        File file = null;
        file = StringUtils.hasLength((String)defaultType) ? new File(this.getRootFolder().getCanonicalPath() + File.separator + defaultType.toLowerCase() + File.separator + modelFile + ".groovy") : new File(this.getRootFolder().getCanonicalPath() + File.separator + modelFile + ".groovy");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        Object pkg = null;
        String[] parts = modelFile.split("[/]");
        String baseClass = writerCls.getCanonicalName().replace("net.ibizsys.codegen.template.rtmodel.dsl", "net.ibizsys.rtmodel.dsl").replace("Writer", "");
        try (FileWriter fileWriter = new FileWriter(file);){
            String strPackage = this.getBasePackage();
            if (StringUtils.hasLength((String)defaultType)) {
                strPackage = strPackage + "." + defaultType.toLowerCase();
            }
            for (int i = 0; i < parts.length - 1; ++i) {
                strPackage = strPackage + "." + parts[i];
            }
            fileWriter.write(String.format("package %1$s", strPackage));
            fileWriter.write("\n");
            fileWriter.write("\n");
            fileWriter.write("import org.springframework.stereotype.Component");
            fileWriter.write("\n");
            fileWriter.write("\n");
            fileWriter.write("@groovy.transform.CompileStatic");
            fileWriter.write("\n");
            fileWriter.write(String.format("@Component(\"%s.%s\")", strPackage, parts[parts.length - 1]));
            fileWriter.write("\n");
            fileWriter.write(String.format("class %1$s extends %2$s {", parts[parts.length - 1], baseClass));
            fileWriter.write("\n");
            fileWriter.write(this.getIndent());
            fileWriter.write(String.format("%1$s() {", parts[parts.length - 1]));
            fileWriter.write("\n");
            fileWriter.write(this.getIndent());
            fileWriter.write(this.getIndent());
            fileWriter.write("tap {");
            fileWriter.write("\n");
            iModelWriter.write(this.getModelDSLGenEngineContext(), (Writer)fileWriter, iPSModelObject, this.getIndent() + this.getIndent() + this.getIndent());
            fileWriter.write(this.getIndent());
            fileWriter.write(this.getIndent());
            fileWriter.write(String.format("}", new Object[0]));
            fileWriter.write("\n");
            fileWriter.write(this.getIndent());
            fileWriter.write(String.format("}", new Object[0]));
            fileWriter.write("\n");
            fileWriter.write(String.format("}", new Object[0]));
        }
        iModelWriter.export(this.getModelDSLGenEngineContext(), iPSModelObject);
    }

    protected String getFileName(IPSModelObject iPSModelObject, String defaultType) throws Exception {
        if (iPSModelObject instanceof IPSCodeList) {
            IPSCodeList iPSCodeList = (IPSCodeList)iPSModelObject;
            if (iPSCodeList.getPSSystemModule() != null) {
                return String.format("modules/%s/codelist/%s", iPSCodeList.getPSSystemModule().getCodeName().toLowerCase(), iPSCodeList.getCodeName());
            }
            return String.format("codelist/%s", iPSCodeList.getCodeName());
        }
        if (iPSModelObject instanceof IPSDataEntity) {
            IPSDataEntity iPSDataEntity = (IPSDataEntity)iPSModelObject;
            return String.format("modules/%s/dataentity/%s", iPSDataEntity.getPSSystemModule().getCodeName().toLowerCase(), iPSDataEntity.getCodeName());
        }
        if (iPSModelObject instanceof IPSDELogic) {
            IPSDELogic iPSDELogic = (IPSDELogic)iPSModelObject;
            IPSDataEntity iPSDataEntity = (IPSDataEntity)iPSDELogic.getParentPSModelObject(IPSDataEntity.class);
            return String.format("modules/%s/dataentity/%s/logic/%s", iPSDataEntity.getPSSystemModule().getCodeName().toLowerCase(), iPSDataEntity.getCodeName().toLowerCase(), iPSDELogic.getCodeName());
        }
        if (iPSModelObject instanceof IPSDEFValueRule) {
            IPSDEFValueRule iPSDEFValueRule = (IPSDEFValueRule)iPSModelObject;
            IPSDEField iPSDEField = (IPSDEField)iPSDEFValueRule.getParentPSModelObject(IPSDEField.class);
            IPSDataEntity iPSDataEntity = (IPSDataEntity)iPSDEField.getParentPSModelObject(IPSDataEntity.class);
            return String.format("modules/%s/dataentity/%s/valuerule/%s/%s", iPSDataEntity.getPSSystemModule().getCodeName().toLowerCase(), iPSDataEntity.getCodeName().toLowerCase(), iPSDEField.getCodeName().toLowerCase(), iPSDEFValueRule.getCodeName());
        }
        if (iPSModelObject instanceof IPSDEMainState) {
            IPSDEMainState iPSDEMainState = (IPSDEMainState)iPSModelObject;
            IPSDataEntity iPSDataEntity = (IPSDataEntity)iPSDEMainState.getParentPSModelObject(IPSDataEntity.class);
            return String.format("modules/%s/dataentity/%s/mainstate/%s", iPSDataEntity.getPSSystemModule().getCodeName().toLowerCase(), iPSDataEntity.getCodeName().toLowerCase(), iPSDEMainState.getCodeName());
        }
        if (iPSModelObject instanceof IPSDEDataImport) {
            IPSDEDataImport iPSDEDataImport = (IPSDEDataImport)iPSModelObject;
            IPSDataEntity iPSDataEntity = (IPSDataEntity)iPSDEDataImport.getParentPSModelObject(IPSDataEntity.class);
            return String.format("modules/%s/dataentity/%s/dataimport/%s", iPSDataEntity.getPSSystemModule().getCodeName().toLowerCase(), iPSDataEntity.getCodeName().toLowerCase(), iPSDEDataImport.getCodeName());
        }
        if (iPSModelObject instanceof IPSDEDataExport) {
            IPSDEDataExport iPSDEDataExport = (IPSDEDataExport)iPSModelObject;
            IPSDataEntity iPSDataEntity = (IPSDataEntity)iPSDEDataExport.getParentPSModelObject(IPSDataEntity.class);
            return String.format("modules/%s/dataentity/%s/dataexport/%s", iPSDataEntity.getPSSystemModule().getCodeName().toLowerCase(), iPSDataEntity.getCodeName().toLowerCase(), iPSDEDataExport.getCodeName());
        }
        if (iPSModelObject instanceof IPSDEPrint) {
            IPSDEPrint iPSDEPrint = (IPSDEPrint)iPSModelObject;
            IPSDataEntity iPSDataEntity = (IPSDataEntity)iPSDEPrint.getParentPSModelObject(IPSDataEntity.class);
            return String.format("modules/%s/dataentity/%s/print/%s", iPSDataEntity.getPSSystemModule().getCodeName().toLowerCase(), iPSDataEntity.getCodeName().toLowerCase(), iPSDEPrint.getCodeName());
        }
        if (iPSModelObject instanceof IPSDEReport) {
            IPSDEReport iPSDEReport = (IPSDEReport)iPSModelObject;
            IPSDataEntity iPSDataEntity = (IPSDataEntity)iPSDEReport.getParentPSModelObject(IPSDataEntity.class);
            return String.format("modules/%s/dataentity/%s/report/%s", iPSDataEntity.getPSSystemModule().getCodeName().toLowerCase(), iPSDataEntity.getCodeName().toLowerCase(), iPSDEReport.getCodeName());
        }
        return super.getFileName(iPSModelObject, defaultType);
    }

    public IModelWriter getModelWriter(Class<?> cls) throws Exception {
        if (this.modelWriterMap.containsKey(cls)) {
            return this.modelWriterMap.get(cls);
        }
        try {
            String strClsEx = cls.getName() + "Ex";
            Class<?> clsEx = Class.forName(strClsEx);
            this.modelWriterMap.put(cls, (IModelWriter)clsEx.newInstance());
            log.info((Object)clsEx.getSimpleName());
            return this.modelWriterMap.get(cls);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return super.getModelWriter(cls);
        }
    }

    public IModelListWriter<?> getModelListWriter(Class<?> cls) throws Exception {
        if (this.modelListWriterMap.containsKey(cls)) {
            return this.modelListWriterMap.get(cls);
        }
        try {
            String strClsEx = cls.getName() + "Ex";
            Class<?> clsEx = Class.forName(strClsEx);
            this.modelListWriterMap.put(cls, (IModelListWriter)clsEx.newInstance());
            log.info((Object)clsEx.getSimpleName());
            return this.modelListWriterMap.get(cls);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return super.getModelListWriter(cls);
        }
    }
}

