package net.ibizsys.codegen.template.rtmodel.dsl;

import net.ibizsys.codegen.template.rtmodel.dsl.IModelWriter;
import net.ibizsys.codegen.template.rtmodel.dsl.ModelDSLGenEngine;
import net.ibizsys.codegen.template.rtmodel.dsl.dataentity.defield.valuerule.DEFVRValueRange2ConditionWriter;
import net.ibizsys.codegen.template.rtmodel.dsl.dataentity.defield.valuerule.DEFVRValueRange2ConditionWriterEx;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.codelist.IPSCodeList;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.dataexport.IPSDEDataExport;
import net.ibizsys.model.dataentity.dataimport.IPSDEDataImport;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.defield.valuerule.IPSDEFValueRule;
import net.ibizsys.model.dataentity.logic.IPSDELogic;
import net.ibizsys.model.dataentity.mainstate.IPSDEMainState;
import net.ibizsys.model.dataentity.print.IPSDEPrint;
import net.ibizsys.model.dataentity.report.IPSDEReport;
import org.springframework.util.StringUtils;

import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Map;

/**
 * @author xignzi
 */
public class GroovyDSLGenEngine extends ModelDSLGenEngine {

    private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(GroovyDSLGenEngine.class);

    private String basePackage = null;

    public GroovyDSLGenEngine(File rootFolder, String basePackage) {
        super(rootFolder);

        this.basePackage = basePackage;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public void export(Class<?> writerCls, IPSModelObject iPSModelObject, String defaultType) throws Exception {
        IModelWriter iModelWriter = this.getModelWriter(writerCls);

        //生产当前文件
        String modelFile = getFileName(iPSModelObject, defaultType);
        File file = null;
        if (StringUtils.hasLength(defaultType)) {
            file = new File(getRootFolder().getCanonicalPath() + File.separator + defaultType.toLowerCase() + File.separator + modelFile + ".groovy");
        } else {
            file = new File(getRootFolder().getCanonicalPath() + File.separator + modelFile + ".groovy");
        }

        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }

        String pkg = null;
        String[] parts = modelFile.split("[/]");
        String baseClass = writerCls.getCanonicalName().replace("net.ibizsys.codegen.template.rtmodel.dsl", "net.ibizsys.rtmodel.dsl").replace("Writer", "");


        try (FileWriter fileWriter = new FileWriter(file)) {
            String strPackage = getBasePackage();

            if (StringUtils.hasLength(defaultType)) {
                strPackage += "." + defaultType.toLowerCase();
            }
            for (int i = 0; i < parts.length - 1; i++) {
                strPackage += "." + parts[i];
            }
            fileWriter.write(String.format("package %1$s", strPackage));
            fileWriter.write("\n");
            fileWriter.write("\n");

            fileWriter.write("import org.springframework.stereotype.Component");
            fileWriter.write("\n");
            fileWriter.write("\n");

            fileWriter.write("@groovy.transform.CompileStatic");
            fileWriter.write("\n");
            fileWriter.write(String.format("@Component(\"%s.%s\")", strPackage, parts[parts.length - 1]));
            fileWriter.write("\n");
            fileWriter.write(String.format("class %1$s extends %2$s {", parts[parts.length - 1], baseClass));
            fileWriter.write("\n");
            fileWriter.write(this.getIndent());
            fileWriter.write(String.format("%1$s() {", parts[parts.length - 1]));
            fileWriter.write("\n");
            fileWriter.write(this.getIndent());
            fileWriter.write(this.getIndent());
            fileWriter.write("tap {");
            fileWriter.write("\n");
            iModelWriter.write(this.getModelDSLGenEngineContext(), fileWriter, iPSModelObject, this.getIndent() + this.getIndent() + this.getIndent());
            fileWriter.write(this.getIndent());
            fileWriter.write(this.getIndent());
            fileWriter.write(String.format("}"));
            fileWriter.write("\n");
            fileWriter.write(this.getIndent());
            fileWriter.write(String.format("}"));
            fileWriter.write("\n");
            fileWriter.write(String.format("}"));
        }

        iModelWriter.export(this.getModelDSLGenEngineContext(), iPSModelObject);
    }

    /**
     * 文件名（目录结构）
     *
     * @param iPSModelObject
     * @param defaultType
     * @return
     * @throws Exception
     */
    @Override
    protected String getFileName(IPSModelObject iPSModelObject, String defaultType) throws Exception {
        if (iPSModelObject instanceof IPSCodeList) {
            IPSCodeList iPSCodeList = (IPSCodeList) iPSModelObject;
            if (iPSCodeList.getPSSystemModule() != null) {
                return String.format("modules/%s/codelist/%s", iPSCodeList.getPSSystemModule().getCodeName().toLowerCase(), iPSCodeList.getCodeName());
            }
            return String.format("codelist/%s", iPSCodeList.getCodeName());
        }

        if (iPSModelObject instanceof IPSDataEntity) {
            IPSDataEntity iPSDataEntity = (IPSDataEntity) iPSModelObject;
            return String.format("modules/%s/dataentity/%s", iPSDataEntity.getPSSystemModule().getCodeName().toLowerCase(), iPSDataEntity.getCodeName());
        }

        if (iPSModelObject instanceof IPSDELogic) {
            IPSDELogic iPSDELogic = (IPSDELogic) iPSModelObject;
            IPSDataEntity iPSDataEntity = iPSDELogic.getParentPSModelObject(IPSDataEntity.class);
            return String.format("modules/%s/dataentity/%s/logic/%s", iPSDataEntity.getPSSystemModule().getCodeName().toLowerCase(), iPSDataEntity.getCodeName().toLowerCase(), iPSDELogic.getCodeName());
        }

        if (iPSModelObject instanceof IPSDEFValueRule) {
            IPSDEFValueRule iPSDEFValueRule = (IPSDEFValueRule) iPSModelObject;
            IPSDEField iPSDEField = iPSDEFValueRule.getParentPSModelObject(IPSDEField.class);
            IPSDataEntity iPSDataEntity = iPSDEField.getParentPSModelObject(IPSDataEntity.class);
            return String.format("modules/%s/dataentity/%s/valuerule/%s/%s", iPSDataEntity.getPSSystemModule().getCodeName().toLowerCase(), iPSDataEntity.getCodeName().toLowerCase(), iPSDEField.getCodeName().toLowerCase(), iPSDEFValueRule.getCodeName());
        }

        if (iPSModelObject instanceof IPSDEMainState) {
            IPSDEMainState iPSDEMainState = (IPSDEMainState) iPSModelObject;
            IPSDataEntity iPSDataEntity = iPSDEMainState.getParentPSModelObject(IPSDataEntity.class);
            return String.format("modules/%s/dataentity/%s/mainstate/%s", iPSDataEntity.getPSSystemModule().getCodeName().toLowerCase(), iPSDataEntity.getCodeName().toLowerCase(), iPSDEMainState.getCodeName());
        }

        if (iPSModelObject instanceof IPSDEDataImport) {
            IPSDEDataImport iPSDEDataImport = (IPSDEDataImport) iPSModelObject;
            IPSDataEntity iPSDataEntity = iPSDEDataImport.getParentPSModelObject(IPSDataEntity.class);
            return String.format("modules/%s/dataentity/%s/dataimport/%s", iPSDataEntity.getPSSystemModule().getCodeName().toLowerCase(), iPSDataEntity.getCodeName().toLowerCase(), iPSDEDataImport.getCodeName());
        }

        if (iPSModelObject instanceof IPSDEDataExport) {
            IPSDEDataExport iPSDEDataExport = (IPSDEDataExport) iPSModelObject;
            IPSDataEntity iPSDataEntity = iPSDEDataExport.getParentPSModelObject(IPSDataEntity.class);
            return String.format("modules/%s/dataentity/%s/dataexport/%s", iPSDataEntity.getPSSystemModule().getCodeName().toLowerCase(), iPSDataEntity.getCodeName().toLowerCase(), iPSDEDataExport.getCodeName());
        }

        if (iPSModelObject instanceof IPSDEPrint) {
            IPSDEPrint iPSDEPrint = (IPSDEPrint) iPSModelObject;
            IPSDataEntity iPSDataEntity = iPSDEPrint.getParentPSModelObject(IPSDataEntity.class);
            return String.format("modules/%s/dataentity/%s/print/%s", iPSDataEntity.getPSSystemModule().getCodeName().toLowerCase(), iPSDataEntity.getCodeName().toLowerCase(), iPSDEPrint.getCodeName());
        }

        if (iPSModelObject instanceof IPSDEReport) {
            IPSDEReport iPSDEReport = (IPSDEReport) iPSModelObject;
            IPSDataEntity iPSDataEntity = iPSDEReport.getParentPSModelObject(IPSDataEntity.class);
            return String.format("modules/%s/dataentity/%s/report/%s", iPSDataEntity.getPSSystemModule().getCodeName().toLowerCase(), iPSDataEntity.getCodeName().toLowerCase(), iPSDEReport.getCodeName());
        }

        return super.getFileName(iPSModelObject, defaultType);
    }


    private Map<Class<?>, IModelWriter> modelWriterMap = new HashMap<Class<?>, IModelWriter>();

    /**
     * Writer 替换重写
     */
    public IModelWriter getModelWriter(Class<?> cls) throws Exception {
        if (modelWriterMap.containsKey(cls)) {
            return modelWriterMap.get(cls);
        }
        try {
            // WriterEx 自动扩展
            String strClsEx = cls.getName() + "Ex";
            Class clsEx = Class.forName(strClsEx);
            this.modelWriterMap.put(cls, (IModelWriter) clsEx.newInstance());
            log.info(clsEx.getSimpleName());
            return modelWriterMap.get(cls);
        } catch (ClassNotFoundException e) {
            //ignore
        }
        return super.getModelWriter(cls);
    }

    private Map<Class<?>, IModelListWriter<?>> modelListWriterMap = new HashMap<Class<?>, IModelListWriter<?>>();

    /**
     * WriterList 替换重写
     *
     * @param cls
     * @return
     * @throws Exception
     */
    public IModelListWriter<?> getModelListWriter(Class<?> cls) throws Exception {
        if (modelListWriterMap.containsKey(cls)) {
            return modelListWriterMap.get(cls);
        }
        try {
            // WriterEx 自动扩展
            String strClsEx = cls.getName() + "Ex";
            Class clsEx = Class.forName(strClsEx);
            this.modelListWriterMap.put(cls, (IModelListWriter) clsEx.newInstance());
            log.info(clsEx.getSimpleName());
            return modelListWriterMap.get(cls);
        } catch (ClassNotFoundException e) {
            //ignore
        }
        return super.getModelListWriter(cls);
    }
}
