package net.ibizsys.codegen.template.rtmodel.dsl.dataentity.report;

import java.io.Writer;

import net.ibizsys.model.IPSModelObject;
import net.ibizsys.codegen.template.rtmodel.dsl.IModelDSLGenEngineContext;

public class DEReportWriterEx extends DEReportWriter {

    protected void onWrite(IModelDSLGenEngineContext iModelDSLGenEngineContext, Writer writer, IPSModelObject object, String indent) throws Exception {

        net.ibizsys.model.dataentity.report.IPSDEReport iPSDEReport = (net.ibizsys.model.dataentity.report.IPSDEReport) object;

        this.write(writer, "codeName", iPSDEReport.getCodeName(), "", indent);
        this.write(writer, "extendMode", iPSDEReport.getExtendMode(), "0", indent);
        this.write(writer, "potime", iPSDEReport.getPOTime(), "-1", indent);
        this.write(writer, "dedataSet", iPSDEReport.getPSDEDataSet(), null, indent);
        this.write(writer, "dedataSet2", iPSDEReport.getPSDEDataSet2(), null, indent);
        this.write(writer, "dedataSet3", iPSDEReport.getPSDEDataSet3(), null, indent);
        this.write(writer, "dedataSet4", iPSDEReport.getPSDEDataSet4(), null, indent);
        if (iPSDEReport.getPSDEReportItems() != null && !iModelDSLGenEngineContext.isExportModelFile(net.ibizsys.model.dataentity.report.IPSDEReport.class, "getPSDEReportItems", false)) {
            writer.write(indent);
            writer.write("items {\n");
            iModelDSLGenEngineContext.write(net.ibizsys.codegen.template.rtmodel.dsl.dataentity.report.DEReportItemListWriter.class, writer, iPSDEReport.getPSDEReportItems(), indent + iModelDSLGenEngineContext.getIndent());
            writer.write(indent);
            writer.write("}\n");
        }
        this.write(writer, "sysSFPlugin", iPSDEReport.getPSSysSFPlugin(), "", indent);
        this.write(writer, "sysUniRes", iPSDEReport.getPSSysUniRes(), "", indent);
        this.write(writer, "reportFile", iPSDEReport.getReportFile(), "", indent);
//		this.write(writer, "reportModel", iPSDEReport.getReportModel(), "", indent);
        this.write(writer, "reportType", iPSDEReport.getReportType(), "", indent);
        this.write(writer, "sysUniResCode", iPSDEReport.getSysUniResCode(), "", indent);
        this.write(writer, "enableLog", iPSDEReport.isEnableLog(), "false", indent);
        this.write(writer, "multiPage", iPSDEReport.isMultiPage(), "false", indent);

        net.ibizsys.model.IPSModelSortable iPSModelSortable = (net.ibizsys.model.IPSModelSortable) object;

        this.write(writer, "orderValue", iPSModelSortable.getOrderValue(), "0", indent);

    }
}