package cn.ibizlab.codegen.groovy.support

import net.ibizsys.model.dataentity.service.IPSDEServiceAPI
import net.ibizsys.model.dataentity.service.IPSDEServiceAPIMethod

class PSDEServiceAPIMethodExtension {

    static String getLogicName(IPSDEServiceAPIMethod iPSDEServiceAPIMethod) {
        if (iPSDEServiceAPIMethod.getPSDEAction() && iPSDEServiceAPIMethod.getPSDEAction().getLogicName()) {
            IPSDEServiceAPI iPSDEServiceAPI = iPSDEServiceAPIMethod.getParentPSModelObject(IPSDEServiceAPI.class)
            if (iPSDEServiceAPIMethod.getPSDEAction().getLogicName().equalsIgnoreCase('getdraft')) {
                return '获取' + iPSDEServiceAPI.getLogicName() + '草稿'
            } else if (iPSDEServiceAPIMethod.getPSDEAction().getLogicName().equalsIgnoreCase('checkkey')) {
                return '检查' + iPSDEServiceAPI.getLogicName() + '主键'
            } else if (iPSDEServiceAPIMethod.getPSDEAction().getLogicName().equalsIgnoreCase('create')) {
                return '创建' + iPSDEServiceAPI.getLogicName()
            } else if (iPSDEServiceAPIMethod.getPSDEAction().getLogicName().equalsIgnoreCase('get')) {
                return '获取' + iPSDEServiceAPI.getLogicName()
            } else if (iPSDEServiceAPIMethod.getPSDEAction().getLogicName().equalsIgnoreCase('update')) {
                return '更新' + iPSDEServiceAPI.getLogicName()
            } else if (iPSDEServiceAPIMethod.getPSDEAction().getLogicName().equalsIgnoreCase('save')) {
                return '保存' + iPSDEServiceAPI.getLogicName()
            } else if (iPSDEServiceAPIMethod.getPSDEAction().getLogicName().equalsIgnoreCase('remove')) {
                return '删除' + iPSDEServiceAPI.getLogicName()
            } else {
                return iPSDEServiceAPIMethod.getPSDEAction().getLogicName()
            }
        }
        if (iPSDEServiceAPIMethod.getPSDEDataSet() && iPSDEServiceAPIMethod.getPSDEDataSet().getLogicName()) {
            return iPSDEServiceAPIMethod.getPSDEDataSet().getLogicName()
        }
        return iPSDEServiceAPIMethod.getName()
    }

    static String getMemo(IPSDEServiceAPIMethod iPSDEServiceAPIMethod) {
        if (iPSDEServiceAPIMethod.getPSDEAction()) {
            return iPSDEServiceAPIMethod.getPSDEAction().getMemo()
        }
        if (iPSDEServiceAPIMethod.getPSDEDataSet()) {
            return iPSDEServiceAPIMethod.getPSDEDataSet().getMemo()
        }
    }
}
