package cn.ibizlab.codegen.groovy.support


import net.ibizsys.model.dataentity.logic.*

public class PSDEMSLogicExtension {

    static String STATE_FORMAT = "state \"%s\" as %s %s [[\$./%s#%s {\"%s\"}]]"

    /**
     * 有条件的 连接
     * @param iPSDEMSLogic
     * @return
     */
    public static List<IPSDEMSLogicLink> getConditionLinks(IPSDEMSLogic iPSDEMSLogic) {
        List<IPSDEMSLogicLink> links = new ArrayList()
        Set<String> flags = new HashSet<>()
        reduceConditionLink(links, iPSDEMSLogic.getDefaultPSDEMSLogicNode(), flags)
        return links
    }

    public static void reduceConditionLink(List links, IPSDEMSLogicNode iPSDEMSLogicNode, Set<String> flags) {
        if (iPSDEMSLogicNode == null || flags.contains(iPSDEMSLogicNode.getId()))
            return
        flags.add(iPSDEMSLogicNode.getId())
        if (iPSDEMSLogicNode.getPSDEMSLogicLinks()) {
            for (IPSDEMSLogicLink iPSDEMSLogicLink : iPSDEMSLogicNode.getPSDEMSLogicLinks()) {
                if (iPSDEMSLogicLink.getPSDEMSLogicLinkGroupCond())
                    links.add(iPSDEMSLogicLink)
                reduceConditionLink(links, iPSDEMSLogicLink.getDstPSDEMSLogicNode(), flags)
            }
        }
    }

    public static String getMdUmlInfo(IPSDEMSLogic iPSDEMSLogic) {
        StringBuffer uml = new StringBuffer()
        uml.append("hide empty description")
        uml.append("\n")

        iPSDEMSLogic.getPSDEMSLogicNodes().each { node ->
//            if (!(node instanceof IPSDEBeginLogic)) {
            uml.append(node.mdUmlStateInfo)
            uml.append("\n")
//            }
        }

        //循环子调用
        iPSDEMSLogic.getPSDEMSLogicNodes().each { node ->
            if (node instanceof IPSDELoopSubCallLogic) {
                String replace = uml.toString().replace("\n" + node.mdUmlStateInfo, "")
                uml.setLength(0)
                uml.append(replace)
                uml.append(node.mdUmlStateInfo)
                uml.append(" #green {")
                uml.append("\n")
                if (node.getPSDEMSLogicLinks()) {
                    node.getPSDEMSLogicLinks().forEach { link ->
//                        if (link.isSubCallLink())
//                            reduceLoopSubNodeInfo(uml, link.getDstPSDEMSLogicNode())
                    }
                }
                uml.append("}\n")
            }
        }


        uml.append("\n")
        uml.append("\n")
        Set<String> flags = new HashSet<>()
        reduceMdUmlInfo(uml, iPSDEMSLogic.getDefaultPSDEMSLogicNode(), flags)
        return uml.toString()
    }


    public static String getMdUmlStateInfo(IPSDEMSLogicNode iPSDEMSLogicNode) {
        IPSDEMSLogic iPSDEMSLogic = iPSDEMSLogicNode.getParentPSModelObject(IPSDEMSLogic.class)
        try {
            String strNodeType = "";
            if (iPSDEMSLogicNode instanceof IPSDEBeginLogic)
                strNodeType = "<<start>>"
            if (iPSDEMSLogicNode instanceof IPSDEEndLogic)
                strNodeType = "<<end>>"
            return String.format(STATE_FORMAT, iPSDEMSLogicNode.getName().replaceAll('”|"', "'"), iPSDEMSLogicNode.getCodeName(),
                    strNodeType,
                    iPSDEMSLogic.getCodeName(), iPSDEMSLogicNode.getCodeName().toLowerCase(), iPSDEMSLogicNode.getName())
        } catch (Exception e) {

        }
    }

    public static void reduceLoopSubNodeInfo(StringBuffer uml, IPSDEMSLogicNode iPSDEMSLogicNode) {
        if (iPSDEMSLogicNode instanceof IPSDEEndLogic || iPSDEMSLogicNode instanceof IPSDELoopSubCallLogic)
            return
        String replace = uml.toString().replace("\n" + iPSDEMSLogicNode.mdUmlStateInfo, "")
        uml.setLength(0)
        uml.append(replace)
        uml.append(iPSDEMSLogicNode.mdUmlStateInfo)
        uml.append("\n")

        if (iPSDEMSLogicNode.getPSDEMSLogicLinks()) {
            iPSDEMSLogicNode.getPSDEMSLogicLinks().forEach { link ->
                reduceLoopSubNodeInfo(uml, link.getDstPSDEMSLogicNode())
            }
        }
    }

    public static void reduceMdUmlInfo(StringBuffer uml, IPSDEMSLogicNode iPSDEMSLogicNode, Set<String> flags) {
        if (iPSDEMSLogicNode == null || flags.contains(iPSDEMSLogicNode.getId()))
            return
        flags.add(iPSDEMSLogicNode.getId())
        if (iPSDEMSLogicNode.getPSDEMSLogicLinks()) {
            for (IPSDEMSLogicLink iPSDEMSLogicLink : iPSDEMSLogicNode.getPSDEMSLogicLinks()) {
                String link = String.format("%s -%s-> %s",
                        iPSDEMSLogicLink.getSrcPSDEMSLogicNode().getCodeName(),
                        "",
                        iPSDEMSLogicLink.getDstPSDEMSLogicNode().getCodeName())
                if (!uml.contains(link)) {
                    uml.append(link)

//                    if (iPSDEMSLogicLink.getPSDEMSLogicLinkGroupCond() && (iPSDEMSLogicLink.getPSDEMSLogicLinkGroupCond().info)) {
//                        uml.append(String.format(" : [[\$./%s#%s{%s} %s]]",
//                                iPSDEMSLogicNode.getParentPSModelObject().getCodeName(),
//                                String.format("%s-%s", iPSDEMSLogicLink.getSrcPSDEMSLogicNode().getCodeName(), iPSDEMSLogicLink.getDstPSDEMSLogicNode().getCodeName()).toLowerCase(),
//                                iPSDEMSLogicLink.getName(),
//                                iPSDEMSLogicLink.getName()))
//                    }
                    if (iPSDEMSLogicLink.getName() && iPSDEMSLogicLink.getName() != '连接名称') {
                        uml.append(String.format(" : %s", iPSDEMSLogicLink.getName()))
                    }
                    uml.append("\n")
                }
                reduceMdUmlInfo(uml, iPSDEMSLogicLink.getDstPSDEMSLogicNode(), flags)
            }

        }
    }

}
