package cn.ibizlab.codegen.groovy.support

import net.ibizsys.model.dataentity.ds.IPSDEDataSet
import net.ibizsys.model.dataentity.logic.IPSDELogicNode
import net.ibizsys.model.dataentity.priv.IPSDEUserRole
import net.ibizsys.model.res.IPSSysSFPluginSupportable
import net.ibizsys.model.security.IPSSysUserRole
import net.ibizsys.model.security.IPSSysUserRoleData
import net.ibizsys.model.util.Conditions

/**
 * 插件link相关
 *
 */
public class PSSysSFPluginExtension {


    /**
     * 插件相关
     * @param iPSSysSFPluginSupportable
     * @return
     */
    public static String getPluginLink(IPSSysSFPluginSupportable iPSSysSFPluginSupportable) {
        if (iPSSysSFPluginSupportable.getPSSysSFPlugin() != null) {
            return String.format("[%s](index/plugin_index#%s)", iPSSysSFPluginSupportable.getPSSysSFPlugin().getName(), iPSSysSFPluginSupportable.getPSSysSFPlugin().getCodeName())
        }
        return ""
    }

    public static String getPluginLink(IPSDEDataSet iPSDEDataSet) {
        if (iPSDEDataSet.getPSSysSFPlugin() != null) {
            return String.format("[%s](index/plugin_index#%s)", iPSDEDataSet.getPSSysSFPlugin().getName(), iPSDEDataSet.getPSSysSFPlugin().getCodeName())
        }
        return ""
    }

    public static String getPluginLink(IPSDELogicNode iPSDELogicNode) {
        if (iPSDELogicNode.getPSSysSFPlugin() != null) {
            return String.format("[%s](index/plugin_index#%s)", iPSDELogicNode.getPSSysSFPlugin().getName(), iPSDELogicNode.getPSSysSFPlugin().getCodeName())
        }
        return ""
    }
}
