package cn.ibizlab.codegen.groovy.support

import com.google.common.base.CaseFormat
import net.ibizsys.model.IPSModelObject
import net.ibizsys.model.dataentity.service.IPSDEMethodDTO
import org.springframework.util.StringUtils

public class PSModelExtension {

    public static String getDisplayName(IPSModelObject iPSModelObject) {
        String logicName = iPSModelObject.getLogicName()
        String name = iPSModelObject.getName()
        String codeName = iPSModelObject.getCodeName()
        if (!logicName) {
            logicName = name
        }
        if (!logicName) {
            logicName = codeName
        }
        if (!name) {
            name = codeName
        }
        if (!(logicName) && !(name))
            return codeName
        if ((logicName) && !(name))
            return logicName
        if (!(logicName) && (name))
            return codeName
        if ((logicName) && (name)) {
            if (logicName.equals(name))
                return logicName
            else
                return String.format("%s(%s)", logicName, name)
        }
    }

    public static String getRealCodeName(IPSModelObject iPSModelObject) {
        String strCodeName = iPSModelObject.getCodeName();
        if (!StringUtils.hasLength(strCodeName)) {
            strCodeName = iPSModelObject.getName();
        }
        if (StringUtils.hasLength(strCodeName)) {
            if (iPSModelObject instanceof IPSDEMethodDTO) {
                IPSDEMethodDTO iPSDEMethodDTO = (IPSDEMethodDTO) iPSModelObject;
                if (iPSDEMethodDTO.getType().equals("DEFILTER")) {
                    strCodeName = strCodeName.replace("FilterDTO", "");
                } else {
                    strCodeName = strCodeName.replace("DTO", "");
                }
                strCodeName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, strCodeName);

                if (iPSDEMethodDTO.getType().equals("DEFILTER")) {
                    strCodeName = strCodeName + "FilterDTO";
                } else {
                    strCodeName = strCodeName + "DTO";
                }
            } else {
                strCodeName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, strCodeName);
            }
        }
        return strCodeName;
    }


}
