package cn.ibizlab.codegen.groovy.support


import net.ibizsys.model.dataentity.action.IPSDEAction
import net.ibizsys.model.dataentity.action.IPSDEActionLogic

public class PSDEActionExtension {

    public static boolean hasActionLogics(IPSDEAction iPSDEAction) {
        if (iPSDEAction.getCheckPSDEActionLogics()) {
            return true
        }
        if (iPSDEAction.getPreparePSDEActionLogics()) {
            return true
        }
        if (iPSDEAction.getBeforePSDEActionLogics()) {
            return true
        }
        if (iPSDEAction.getAfterPSDEActionLogics()) {
            return true
        }
        return false
    }

    public static List getActionLogics(IPSDEAction iPSDEAction) {
        List<IPSDEActionLogic> actionLogics = new ArrayList<>()
        if (iPSDEAction.getCheckPSDEActionLogics()) {
            actionLogics.addAll(iPSDEAction.getCheckPSDEActionLogics())
        }
        if (iPSDEAction.getPreparePSDEActionLogics()) {
            actionLogics.addAll(iPSDEAction.getPreparePSDEActionLogics())
        }
        if (iPSDEAction.getBeforePSDEActionLogics()) {
            actionLogics.addAll(iPSDEAction.getBeforePSDEActionLogics())
        }
        if (iPSDEAction.getAfterPSDEActionLogics()) {
            actionLogics.addAll(iPSDEAction.getAfterPSDEActionLogics())
        }
        return actionLogics
    }

    public static List getActionLogicInfo(IPSDEAction iPSDEAction) {
        List<String> infos = new ArrayList<>()
        List<IPSDEActionLogic> actionLogics = getActionLogics(iPSDEAction)
        actionLogics.forEach { actionLogic ->
            if (actionLogic.getPSDELogic() != null) {
                infos.add(actionLogic.getPSDELogic().getLogicName())
            }
            if (actionLogic.getDstPSDEAction() != null) {
                actionLogic.getDstPSDE()
                infos.add(actionLogic.getDstPSDEAction().getLogicName())
            }
            if (actionLogic.getPSDENotify() != null) {
                infos.add(actionLogic.getPSDENotify().getLogicName())
            }
            if (actionLogic.getPSSysLogic() != null) {
                infos.add(actionLogic.getPSSysLogic().getLogicName())
            }
            if (actionLogic.getPSSysSequence() != null) {
                infos.add(actionLogic.getPSSysSequence().getLogicName())
            }
            if (actionLogic.getPSDEMainState() != null) {
                infos.add(actionLogic.getPSDEMainState().getLogicName())
            }
            if (actionLogic.getPSDEDataSync() != null) {
                infos.add(actionLogic.getPSDEDataSync().getLogicName())
            }
            if (actionLogic.getMajorPSDER() != null) {
                infos.add(actionLogic.getMajorPSDER().getLogicName())
            }
            if (actionLogic.getPSSysTranslator() != null) {
                infos.add(actionLogic.getPSSysTranslator().getLogicName())
            }
            if (actionLogic.getPSDEFValueRule() != null) {
                infos.add(actionLogic.getPSDEFValueRule().getLogicName())
            }
            if (actionLogic.getDstPSDEDataSet() != null) {
                infos.add(actionLogic.getDstPSDEDataSet().getLogicName())
            }
        }
        return String.join("、", infos)
    }

    public static String getInfo(IPSDEActionLogic iPSDEActionLogic) {
        String strInfo = ""
        return strInfo
    }

}
