/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.service;

import cn.ibizlab.util.security.AuthenticationInfo;
import cn.ibizlab.util.security.AuthenticationUser;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.ObjectUtils;

public interface UserServiceAdapter {
    public static final DateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    default public AuthenticationUser loadUserByUsername(String username) {
        return null;
    }

    default public AuthenticationInfo loadUserByLogin(String username, String password) {
        return null;
    }

    default public Map getAppData(String systemId, boolean isEnablePermissionValid) {
        HashMap<String, Object> appData = new HashMap<String, Object>();
        HashSet<String> appMenu = new HashSet<String>();
        HashSet<String> uniRes = new HashSet<String>();
        AuthenticationUser curUser = AuthenticationUser.getAuthenticationUser();
        if (isEnablePermissionValid && !ObjectUtils.isEmpty((Object)systemId)) {
            Collection<GrantedAuthority> authorities = curUser.getAuthorities();
            for (GrantedAuthority authority : authorities) {
                String strAuthority = authority.getAuthority();
                if (strAuthority.startsWith("UNIRES_" + systemId)) {
                    uniRes.add(strAuthority.substring(systemId.length() + 8));
                    continue;
                }
                if (!strAuthority.startsWith("APPMENU_" + systemId)) continue;
                appMenu.add(strAuthority.substring(systemId.length() + 9));
            }
        }
        if (!ObjectUtils.isEmpty((Object)curUser.getExpiration())) {
            appData.put("expireddate", dtFormat.format(curUser.getExpiration()));
        }
        HashMap<String, String> context = new HashMap<String, String>();
        context.putAll(curUser.getSessionParams());
        context.put("srfusername", curUser.getDisplayName());
        appData.put("context", context);
        appData.put("unires", uniRes);
        appData.put("appmenu", appMenu);
        appData.put("enablepermissionvalid", isEnablePermissionValid);
        if (curUser.isSuperUser()) {
            appData.put("enablepermissionvalid", false);
        } else {
            appData.put("enablepermissionvalid", isEnablePermissionValid);
        }
        return appData;
    }

    default public Map<String, List<String>> getOrgInfo(String organizationId, String departmentId) {
        return new HashMap<String, List<String>>();
    }

    default public String getSecret() {
        return "ibzsecret";
    }

    default public Long getExpiration() {
        return 0x6DDD00L;
    }

    default public String generateToken(UserDetails userDetails) {
        try {
            Date now = new Date();
            MACSigner signer = new MACSigner(this.getSecret());
            JWSHeader header = new JWSHeader.Builder(JWSAlgorithm.HS512).contentType("JWS").build();
            JWTClaimsSet claimsSet = new JWTClaimsSet.Builder().subject(userDetails.getUsername()).issueTime(now).expirationTime(new Date(now.getTime() + this.getExpiration())).build();
            SignedJWT signedJWT = new SignedJWT(header, claimsSet);
            signedJWT.sign((JWSSigner)signer);
            return signedJWT.serialize();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public String getUsernameFromToken(String token) {
        try {
            SignedJWT signedJWT = SignedJWT.parse((String)token);
            JWTClaimsSet claimsSet = signedJWT.getJWTClaimsSet();
            return claimsSet.getSubject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public Date getExpirationDateFromToken(String token) {
        try {
            SignedJWT signedJWT = SignedJWT.parse((String)token);
            JWTClaimsSet claimsSet = signedJWT.getJWTClaimsSet();
            return claimsSet.getExpirationTime();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public Boolean validateToken(String token, UserDetails userDetails) {
        try {
            Date now = new Date();
            MACVerifier verifier = new MACVerifier(this.getSecret());
            SignedJWT signedJWT = SignedJWT.parse((String)token);
            JWTClaimsSet claimsSet = signedJWT.getJWTClaimsSet();
            if (signedJWT.verify((JWSVerifier)verifier) && now.before(claimsSet.getExpirationTime())) {
                if (userDetails instanceof AuthenticationUser) {
                    AuthenticationUser user = (AuthenticationUser)userDetails;
                    user.setToken(token);
                    user.setExpiration(claimsSet.getExpirationTime());
                }
                return true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return false;
    }
}

