/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.service;

import cn.ibizlab.util.client.UaaFeignClient;
import cn.ibizlab.util.errors.BadRequestAlertException;
import cn.ibizlab.util.security.AuthUser20Impl;
import cn.ibizlab.util.security.AuthenticationInfo;
import cn.ibizlab.util.security.AuthenticationUser;
import cn.ibizlab.util.security.AuthorizationLogin;
import cn.ibizlab.util.service.UserServiceAdapter;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service(value="IBZUAAUserService")
@ConditionalOnExpression(value=" '${ibiz.ref.service.rt.version:}'.equals('RT2') || '${ibiz.auth.service:Uaa20UserService}'.equals('Uaa20UserService') ")
public class Uaa20UserService
implements UserServiceAdapter {
    @Value(value="${ibiz.jwt.secret:MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBAKaTz4pgOR/p0RjlczM0dErf4ZUNziE/HJcfKDLPu77Gs2EJdDK0uGfPI3GX/eRwX9L9bTZJtz9sX2fkRqRt3gWnsMypT2P/cO/2GgtRCPHRFD7BI+Df32isEJZ6M4kD9tyKLw8Y9KuP0C20ZMMDeCrrbjMagMMrwTOM4/4eFjzVAgMBAAECgYEAnH3mj2hgolOmhg4hkOxpiGIV6lMi4OcKtAqoWDwCdHL12GbqTCytxZC7Cp+w/Wh5DZ3aeRL93c6xPsgdeaJh3kYa4ooo6b5tFHPU63VU5MBgwGzi26/6GB4GCXxGMB+SxmdigDmmPIYbXD+jO2oj1s8hj+DOE4U2fIjeZ//DumECQQDlA74KHNZlKxoWl0FoHCgcIHFBZcQWKO3puhrH7VsRYI7CVVguE57NBT6QvAmU9r32PDt64tS0Qd1sCrk4uEqtAkEAujSj/cwF4ctQZCbUoMMzK/mw8ZxW3M6VK3urbq8fyFJ2iT2aLV3jE3+tnDdpezcfnbs/9SVXeFmJpdg/L7hnyQJAQyxo1qCExmHxIgU1uyrfHPjrH2qRLIrO1gqvhkr5tkwjM59C4SkCIFLUejGdgeMp7wrVy4KzLzhOkT1H/PoZdQJAEbKxJ409veFKKcq7CPCkq3hXBg/a/a+w4+okOCfy+GJGG/M79TXoQFExWhi2MNzjZ2WFxbIf5zNzbszn7Iw1aQJBAIXpKrQ0sLxr0rFzsoHBrobPcnQeutzypQNTPkoItILVP9pWz+aUfIKnOHEC5GAdD2LPZZ/pF7ixdRd9nBab+pk=}")
    private String secret;
    @Value(value="${ibiz.jwt.expiration:7200000}")
    private Long expiration;
    @Value(value="${ibiz.jwt.signature:MAC}")
    private String signature;
    @Autowired
    private UaaFeignClient uaaFeignClient;
    protected SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected static final String SIGNATURE_RSA = "RSA";
    protected static final String SIGNATURE_MAC = "MAC";

    @Override
    public AuthenticationInfo loadUserByLogin(String username, String password) {
        String[] data = username.split("[|]");
        String loginname = username;
        String domains = "";
        if (data.length == 2) {
            loginname = data[0].trim();
            domains = data[1].trim();
        }
        AuthorizationLogin logininfo = new AuthorizationLogin();
        logininfo.setDomain(domains);
        logininfo.setLoginname(loginname);
        logininfo.setPassword(password);
        AuthenticationInfo info = this.uaaFeignClient.login(logininfo);
        if (info.getUser() == null) {
            throw new BadRequestAlertException("\u767b\u5f55\u5931\u8d25", "IBZUAAUser", username);
        }
        return info;
    }

    @Override
    public AuthenticationUser loadUserByUsername(String username) {
        AuthUser20Impl authUser = this.uaaFeignClient.loadUserByUsername(username);
        return authUser;
    }

    @Override
    public Map<String, Object> getAppData(String systemId, boolean isEnablePermissionValid) {
        HashMap<String, Object> appData = new HashMap<String, Object>();
        HashSet appMenu = new HashSet();
        HashSet uniRes = new HashSet();
        AuthenticationUser user = AuthenticationUser.getAuthenticationUser();
        Collection<GrantedAuthority> authorities = user.getAuthorities();
        if (isEnablePermissionValid && !ObjectUtils.isEmpty((Object)systemId) && !ObjectUtils.isEmpty(authorities)) {
            authorities.forEach(item -> {
                String authority = item.getAuthority();
                if (authority.startsWith(systemId)) {
                    uniRes.add(authority);
                }
                if (authority.startsWith(String.format("%1$s-APPMENU", systemId))) {
                    appMenu.add(authority.substring(systemId.length() + 9));
                }
            });
        }
        if (!ObjectUtils.isEmpty((Object)user.getExpiration())) {
            appData.put("expireddate", dtFormat.format(user.getExpiration()));
        }
        HashMap<String, String> context = new HashMap<String, String>();
        context.putAll(user.getSessionParams());
        context.put("srfusername", user.getDisplayName());
        appData.put("context", context);
        appData.put("unires", uniRes);
        appData.put("appmenu", appMenu);
        appData.put("enablepermissionvalid", !user.isSuperUser() && isEnablePermissionValid);
        return appData;
    }

    @Override
    public Map<String, List<String>> getOrgInfo(String organizationId, String departmentId) {
        return this.uaaFeignClient.getOrgInfo(organizationId, departmentId);
    }

    @Override
    public String generateToken(UserDetails userDetails) {
        if (ObjectUtils.isEmpty((Object)this.signature) || SIGNATURE_MAC.equalsIgnoreCase(this.signature)) {
            return this.generateTokenByMAC(userDetails);
        }
        throw new RuntimeException(String.format("\u751f\u6210\u8bbf\u95ee\u4ee4\u724c\u51fa\u9519\uff0c\u7b7e\u540d\u6682\u672a\u652f\u6301[%1$s]\u52a0\u5bc6\u7b97\u6cd5", this.signature));
    }

    protected String generateTokenByMAC(UserDetails userDetails) {
        try {
            Date now = new Date();
            MACSigner signer = new MACSigner(this.getSecret());
            JWSHeader header = new JWSHeader.Builder(JWSAlgorithm.HS512).contentType("JWS").build();
            JWTClaimsSet claimsSet = new JWTClaimsSet.Builder().subject(userDetails.getUsername()).issueTime(now).expirationTime(new Date(now.getTime() + this.getExpiration())).build();
            SignedJWT signedJWT = new SignedJWT(header, claimsSet);
            signedJWT.sign((JWSSigner)signer);
            return signedJWT.serialize();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Boolean validateToken(String token, UserDetails userDetails) {
        if (ObjectUtils.isEmpty((Object)this.signature) || SIGNATURE_MAC.equalsIgnoreCase(this.signature)) {
            return this.validateTokenByMAC(token, userDetails);
        }
        if (SIGNATURE_RSA.equalsIgnoreCase(this.signature)) {
            return this.validateTokenByRSA(token, userDetails);
        }
        throw new RuntimeException(String.format("\u9a8c\u8bc1\u8bbf\u95ee\u4ee4\u724c\u51fa\u9519\uff0c\u7b7e\u540d\u6682\u672a\u652f\u6301[%1$s]\u52a0\u5bc6\u7b97\u6cd5", this.signature));
    }

    protected Boolean validateTokenByMAC(String token, UserDetails userDetails) {
        try {
            Date now = new Date();
            MACVerifier verifier = new MACVerifier(this.getSecret());
            SignedJWT signedJWT = SignedJWT.parse((String)token);
            JWTClaimsSet claimsSet = signedJWT.getJWTClaimsSet();
            if (signedJWT.verify((JWSVerifier)verifier) && now.before(claimsSet.getExpirationTime())) {
                if (userDetails instanceof AuthenticationUser) {
                    AuthenticationUser user = (AuthenticationUser)userDetails;
                    user.setToken(token);
                    user.setExpiration(claimsSet.getExpirationTime());
                }
                return true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    protected Boolean validateTokenByRSA(String token, UserDetails userDetails) {
        try {
            String signatureKey = this.uaaFeignClient.signatureKey();
            if (ObjectUtils.isEmpty((Object)signatureKey)) {
                throw new RuntimeException("\u9a8c\u8bc1\u8bbf\u95ee\u4ee4\u724c\u51fa\u9519\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u516c\u94a5\u4fe1\u606f");
            }
            Date now = new Date();
            RSAKey publicJWK = RSAKey.parse((String)signatureKey);
            RSASSAVerifier verifier = new RSASSAVerifier(publicJWK);
            SignedJWT signedJWT = SignedJWT.parse((String)token);
            JWTClaimsSet claimsSet = signedJWT.getJWTClaimsSet();
            if (!signedJWT.verify((JWSVerifier)verifier)) {
                return false;
            }
            if (now.after(claimsSet.getExpirationTime())) {
                throw new RuntimeException(String.format("\u8bbf\u95ee\u4ee4\u724c\u5df2\u8fc7\u671f\uff0c\u4ee4\u724c\u6709\u6548\u671f\u4e3a[%1$s]\uff0c\u5f53\u524d\u65f6\u95f4\u4e3a[%2$s]", this.sdf.format(claimsSet.getExpirationTime()), this.sdf.format(now)));
            }
            AuthenticationUser user = (AuthenticationUser)userDetails;
            user.set("token", token);
            user.set("expiration", claimsSet.getExpirationTime());
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getSecret() {
        return this.secret;
    }

    @Override
    public Long getExpiration() {
        return this.expiration;
    }
}

