/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.service;

import cn.ibizlab.util.domain.FileItem;
import cn.ibizlab.util.errors.InternalServerErrorException;
import cn.ibizlab.util.security.AuthenticationUser;
import cn.ibizlab.util.service.FileService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;

@Primary
@Service
public class SimpleFileService
implements FileService {
    private static final Logger log = LoggerFactory.getLogger(SimpleFileService.class);
    @Value(value="${ibiz.filePath:/app/file/}")
    private String fileRoot;

    @Override
    public FileItem saveFile(MultipartFile multipartFile) {
        FileItem item = null;
        String name = multipartFile.getOriginalFilename();
        try {
            String id = DigestUtils.md5DigestAsHex((InputStream)multipartFile.getInputStream());
            Path path = Paths.get(this.fileRoot, "ibizutil", id, name);
            File parent = path.getParent().toFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            FileCopyUtils.copy((InputStream)multipartFile.getInputStream(), (OutputStream)Files.newOutputStream(path, new OpenOption[0]));
            item = new FileItem().setId(id).setName(name).setTime(new Date()).setAuthor(AuthenticationUser.getAuthenticationUser().getDisplayName());
        }
        catch (IOException e) {
            throw new InternalServerErrorException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c" + e);
        }
        return item;
    }

    @Override
    public File getFile(String fileid) {
        File parent = Paths.get(this.fileRoot, "ibizutil", fileid).toFile();
        if (parent.exists() && parent.isDirectory() && parent.listFiles().length > 0) {
            return parent.listFiles()[0];
        }
        throw new InternalServerErrorException("\u6587\u4ef6\u672a\u627e\u5230");
    }
}

