/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.service;

import cn.ibizlab.util.security.AuthenticationInfo;
import cn.ibizlab.util.security.AuthenticationUser;
import cn.ibizlab.util.service.AuthenticationUserService;
import cn.ibizlab.util.service.UserServiceAdapter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.security.core.userdetails.UserDetails;

public abstract class AbstractAuthUserService
implements AuthenticationUserService {
    @Autowired
    protected UserServiceAdapter userServiceAdapter;
    @Value(value="${ibiz.enablePermissionValid:false}")
    boolean enablePermissionValid;
    @Value(value="${ibiz.systemid}")
    private String systemId;

    @Override
    @Cacheable(value={"ibzuaa_users"}, key="#root.target.systemId+':getByUsername:'+#p0")
    public AuthenticationUser loadUserByUsername(String username) {
        return this.createAuthenticationUser(this.userServiceAdapter.loadUserByUsername(username));
    }

    protected AuthenticationUser createAuthenticationUser(AuthenticationUser adapterUser) {
        AuthenticationUser user = adapterUser;
        return user;
    }

    @Override
    public AuthenticationInfo loadUserByLogin(String username, String password) {
        return this.userServiceAdapter.loadUserByLogin(username, password);
    }

    @Override
    @CacheEvict(value={"ibzuaa_users"}, key="'glob:*getByUsername:'+#p0")
    public void resetByUsername(String username) {
    }

    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public Map getAppData() {
        return this.userServiceAdapter.getAppData(this.systemId, this.enablePermissionValid);
    }

    @Override
    public Map<String, List<String>> getOrgInfo(String organizationId, String departmentId) {
        return this.userServiceAdapter.getOrgInfo(organizationId, departmentId);
    }

    @Override
    public String generateToken(UserDetails userDetails) {
        return this.userServiceAdapter.generateToken(userDetails);
    }

    @Override
    public Boolean validateToken(String token, UserDetails userDetails) {
        return this.userServiceAdapter.validateToken(token, userDetails);
    }

    @Override
    public String getUsernameFromToken(String token) {
        return this.userServiceAdapter.getUsernameFromToken(token);
    }

    @Override
    public Date getExpirationDateFromToken(String token) {
        return this.userServiceAdapter.getExpirationDateFromToken(token);
    }
}

