/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.security;

import cn.ibizlab.util.security.AuthenticationContextHolder;
import cn.ibizlab.util.security.AuthenticationUser;
import cn.ibizlab.util.service.AuthenticationUserService;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class AuthorizationTokenFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationTokenFilter.class);
    private final UserDetailsService userDetailsService;
    private final String tokenHeader;
    @Value(value="${ibiz.auth.excludesPattern:}")
    private String[] excludesPattens;
    private PathMatcher pathMatcher = new AntPathMatcher();

    private boolean isExclusion(String requestURI) {
        if (this.excludesPattens == null) {
            return false;
        }
        for (String pattern : this.excludesPattens) {
            if (!this.pathMatcher.match(pattern, requestURI)) continue;
            return true;
        }
        return false;
    }

    public AuthorizationTokenFilter(UserDetailsService userDetailsService, @Value(value="${ibiz.jwt.header:Authorization}") String tokenHeader) {
        this.userDetailsService = userDetailsService;
        this.tokenHeader = tokenHeader;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (this.isExclusion(request.getRequestURI())) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (SecurityContextHolder.getContext().getAuthentication() != null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String requestHeader = request.getHeader(this.tokenHeader);
        if (!"Authorization".equalsIgnoreCase(this.tokenHeader) && ObjectUtils.isEmpty((Object)requestHeader)) {
            requestHeader = request.getHeader("Authorization");
        }
        String username = null;
        String authToken = null;
        if (requestHeader != null && requestHeader.startsWith("Bearer ")) {
            authToken = requestHeader.substring(7);
            try {
                username = ((AuthenticationUserService)this.userDetailsService).getUsernameFromToken(authToken);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        if (username != null && SecurityContextHolder.getContext().getAuthentication() == null) {
            UserDetails userDetails = this.userDetailsService.loadUserByUsername(username);
            boolean validate = true;
            if (this.userDetailsService instanceof AuthenticationUserService) {
                validate = ((AuthenticationUserService)this.userDetailsService).validateToken(authToken, userDetails);
                if (userDetails instanceof AuthenticationUser) {
                    AuthenticationUser curUser = (AuthenticationUser)userDetails;
                    curUser.readHeader(false);
                    if (!ObjectUtils.isEmpty((Object)curUser.getOrganizationId())) {
                        Map<String, List<String>> orgInfo = ((AuthenticationUserService)this.userDetailsService).getOrgInfo(curUser.getOrganizationId(), curUser.getDepartmentId() == null ? "null" : curUser.getDepartmentId());
                        curUser.getParentOrgIds().addAll(orgInfo.getOrDefault("organization_parent_ids", Collections.emptyList()));
                        curUser.getSubOrgIds().addAll(orgInfo.getOrDefault("organization_sub_ids", Collections.emptyList()));
                        curUser.getParentDeptIds().addAll(orgInfo.getOrDefault("department_parent_ids", Collections.emptyList()));
                        curUser.getCurOrgIds().addAll(orgInfo.getOrDefault("department_sub_ids", Collections.emptyList()));
                    }
                    AuthenticationContextHolder.setContext((AuthenticationUser)userDetails);
                }
            }
            if (validate) {
                UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                authentication.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
                SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

