/*
 * Decompiled with CFR 0.152.
 */
package cn.ibizlab.util.security;

import cn.ibizlab.util.security.AuthMember;
import cn.ibizlab.util.security.AuthenticationContextHolder;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public interface AuthenticationUser
extends UserDetails {
    default public String getUsername() {
        return (String)this.get("username");
    }

    default public void setUsername(String username) {
        this.put("username", username);
    }

    default public String getDisplayName() {
        return (String)this.get("display_name|personname");
    }

    default public void setDisplayName(String displayName) {
        this.put("display_name", displayName);
    }

    default public String getId() {
        return (String)this.get("id|userid|username");
    }

    default public void setId(String id) {
        this.put("id", id);
    }

    default public String getDc() {
        return (String)this.get("dc|srfdcid|domain|tenant|tenant_id");
    }

    default public void setDc(String dc) {
        this.put("dc", dc);
    }

    default public String getOrganizationId() {
        return (String)this.get("organization_id|orgid|srforgid");
    }

    default public void setOrganizationId(String organizationId) {
        this.put("organization_id", organizationId);
    }

    default public String getOrganizationNumber() {
        return (String)this.get("organization_number|orgcode|srforgcode");
    }

    default public void setOrganizationNumber(String organizationNumber) {
        this.put("organization_number", organizationNumber);
    }

    default public String getOrganizationName() {
        return (String)this.get("organization_name|orgname|srforgname");
    }

    default public void setOrganizationName(String organizationName) {
        this.put("organization_name", organizationName);
    }

    default public String getDepartmentId() {
        return (String)this.get("department_id|mdeptid|srforgsectorid");
    }

    default public void setDepartmentId(String departmentId) {
        this.put("department_id", departmentId);
    }

    default public String getDepartmentNumber() {
        return (String)this.get("department_number|mdeptcode|srforgsectorcode");
    }

    default public void setDepartmentNumber(String departmentNumber) {
        this.put("department_number", departmentNumber);
    }

    default public String getDepartmentName() {
        return (String)this.get("department_name|mdeptname|srforgsectorname");
    }

    default public void setDepartmentName(String departmentName) {
        this.put("department_name", departmentName);
    }

    default public String getOrganizationalRoleId() {
        return (String)this.get("organizational_role_id|curteamid");
    }

    default public void setOrganizationalRoleId(String organizationalRoleId) {
        this.put("organizational_role_id", organizationalRoleId);
    }

    default public String getOrganizationalRoleName() {
        return (String)this.get("organizational_role_name|curteamname");
    }

    default public void setOrganizationalRoleName(String organizationalRoleName) {
        this.put("organizational_role_name", organizationalRoleName);
    }

    default public String getDeploySystemId() {
        return (String)this.get("deploy_system_id|dcsystemid|srfdcsystemid");
    }

    default public void setDeploySystemId(String deploySystemId) {
        this.put("deploy_system_id", deploySystemId);
    }

    default public String getSystemId() {
        return (String)this.get("system_id|srfsystemid");
    }

    default public void setSystemId(String systemId) {
        this.put("system_id", systemId);
    }

    default public String getEmployeeNumber() {
        return (String)this.get("employee_number|usercode");
    }

    default public void setEmployeeNumber(String employeeNumber) {
        this.put("employee_number", employeeNumber);
    }

    default public String getEmployeeType() {
        return (String)this.get("employee_type");
    }

    default public void setEmployeeType(String employeeType) {
        this.put("employee_type", employeeType);
    }

    default public String getTitle() {
        return (String)this.get("title|postname");
    }

    default public void setTitle(String title) {
        this.put("title", title);
    }

    default public String getMail() {
        return (String)this.get("mail|email");
    }

    default public void setMail(String mail) {
        this.put("mail", mail);
    }

    default public String getTelephoneNumber() {
        return (String)this.get("telephone_number|phone");
    }

    default public void setTelephoneNumber(String telephoneNumber) {
        this.put("telephone_number", telephoneNumber);
    }

    default public String getMobile() {
        return (String)this.get("mobile|phone");
    }

    default public void setMobile(String mobile) {
        this.put("mobile", mobile);
    }

    default public String getIdentificationNumber() {
        return (String)this.get("identification_number|certcode");
    }

    default public void setIdentificationNumber(String identificationNumber) {
        this.put("identification_number", identificationNumber);
    }

    default public String getPostalAddress() {
        return (String)this.get("postal_address|addr");
    }

    default public void setPostalAddress(String postalAddress) {
        this.put("postal_address", postalAddress);
    }

    default public String getDescription() {
        return (String)this.get("description|memo");
    }

    default public void setDescription(String description) {
        this.put("description", description);
    }

    @JsonIgnore
    @JSONField(serialize=false)
    default public boolean isSuperUser() {
        return Integer.valueOf(1).equals(this.get("superuser"));
    }

    default public void setSuperUser(Integer superUser) {
        this.put("superuser", superUser);
    }

    @JsonIgnore
    @JSONField(serialize=false)
    default public boolean isApiUser() {
        return Integer.valueOf(1).equals(this.get("apiuser"));
    }

    default public void setApiUser(Integer apiUser) {
        this.put("apiuser", apiUser);
    }

    default public String getDeviceInfo() {
        return (String)this.get("device_info|user_agent");
    }

    default public void setDeviceInfo(String deviceInfo) {
        this.put("device_info", deviceInfo);
    }

    default public String getClientIp() {
        return (String)this.get("client_ip|ip|referer");
    }

    default public void setClientIp(String clientIp) {
        this.put("client_ip", clientIp);
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale="zh", timezone="GMT+8")
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    default public Date getExpiration() {
        return (Date)this.get("expiration");
    }

    default public void setExpiration(Date expiration) {
        this.put("expiration", expiration);
    }

    default public String getToken() {
        return (String)this.get("token");
    }

    default public void setToken(String token) {
        this.put("token", token);
    }

    @JsonIgnore
    @JSONField(serialize=false)
    default public boolean isAccountNonExpired() {
        return this.getExpiration() == null ? true : !this.getExpiration().before(new Date());
    }

    @JsonIgnore
    @JSONField(serialize=false)
    default public boolean isAccountNonLocked() {
        return true;
    }

    @JsonIgnore
    @JSONField(serialize=false)
    default public boolean isCredentialsNonExpired() {
        return true;
    }

    @JsonIgnore
    @JSONField(serialize=false)
    default public String getPassword() {
        return null;
    }

    default public void setPassword(String password) {
        this.put("password", password);
    }

    default public boolean isEnabled() {
        return true;
    }

    @JsonIgnore
    @JSONField(serialize=false)
    public Collection<GrantedAuthority> getAuthorities();

    @JsonIgnore
    @JSONField(serialize=false)
    public Map<String, Object> getExtensionparams();

    @JsonIgnore
    @JSONField(serialize=false)
    default public Map getSessionParams() {
        return this.getExtensionparams();
    }

    @JsonAnyGetter
    @JSONField(name="_any", unwrapped=true, serialize=true, deserialize=false)
    default public Map<String, Object> any() {
        return this.getExtensionparams();
    }

    @JsonAnySetter
    @JSONField(name="_any", unwrapped=true, serialize=false, deserialize=true)
    default public void set(String field, Object value) {
        if (this.getExtensionparams() != null) {
            this.getExtensionparams().put(field, value);
        }
    }

    default public void put(String field, Object value) {
        this.set(field, value);
    }

    default public Object get(String field) {
        return this.get(field, null);
    }

    default public Object get(String field, Object defaultValue) {
        if (this.any() != null) {
            for (String key : field.split("[|]")) {
                Object obj = this.any().get(key);
                if (obj == null) continue;
                return obj;
            }
        }
        return defaultValue;
    }

    default public void readHeader(boolean change) {
    }

    default public void setMemberOf(List<AuthMember> memberOf) {
        this.put("member_of", memberOf);
    }

    default public List<AuthMember> getMemberOf() {
        return (List)this.get("member_of", new ArrayList());
    }

    default public void setCurMemberOf(AuthMember curMemberOf) {
        this.put("cur_member_of", curMemberOf);
        if (curMemberOf != null) {
            this.setOrganizationId(curMemberOf.getOrganizationId());
            this.setOrganizationNumber(curMemberOf.getOrganizationNumber());
            this.setOrganizationName(curMemberOf.getOrganizationName());
            this.setDepartmentId(curMemberOf.getDepartmentId());
            this.setDepartmentNumber(curMemberOf.getDepartmentNumber());
            this.setDepartmentName(curMemberOf.getDepartmentName());
            this.setOrganizationalRoleId(curMemberOf.getOrganizationalRoleId());
            this.setOrganizationalRoleName(curMemberOf.getOrganizationalRoleName());
            if (!ObjectUtils.isEmpty((Object)curMemberOf.getDc())) {
                this.setDc(curMemberOf.getDc());
            }
        }
    }

    default public AuthMember getCurMemberOf() {
        return (AuthMember)this.get("cur_member_of", !ObjectUtils.isEmpty(this.getMemberOf()) ? this.getMemberOf().get(0) : null);
    }

    @JsonIgnore
    @JSONField(serialize=false)
    default public Set<String> getCurOrgIds() {
        if (this.getMemberOf() != null) {
            return new LinkedHashSet<String>(this.getMemberOf().stream().filter(e -> !ObjectUtils.isEmpty((Object)e.getOrganizationId())).map(e -> e.getOrganizationId()).collect(Collectors.toList()));
        }
        return new LinkedHashSet<String>(Arrays.asList(this.getOrganizationId()));
    }

    @JsonIgnore
    @JSONField(serialize=false)
    default public Set getParentOrgIds() {
        return new HashSet();
    }

    @JsonIgnore
    @JSONField(serialize=false)
    default public Set getSubOrgIds() {
        return this.getCurOrgIds();
    }

    @JsonIgnore
    @JSONField(serialize=false)
    default public Set<String> getCurDeptIds() {
        if (this.getMemberOf() != null) {
            return new LinkedHashSet<String>(this.getMemberOf().stream().filter(e -> !ObjectUtils.isEmpty((Object)e.getDepartmentId())).map(e -> e.getDepartmentId()).collect(Collectors.toList()));
        }
        return new LinkedHashSet<String>(Arrays.asList(this.getDepartmentId()));
    }

    @JsonIgnore
    @JSONField(serialize=false)
    default public Set getParentDeptIds() {
        return new HashSet();
    }

    @JsonIgnore
    @JSONField(serialize=false)
    default public Set getSubDeptIds() {
        return this.getCurDeptIds();
    }

    @JsonIgnore
    @JSONField(serialize=false)
    default public Set<String> getCurTeamIds() {
        if (this.getMemberOf() != null) {
            return new LinkedHashSet<String>(this.getMemberOf().stream().filter(e -> !ObjectUtils.isEmpty((Object)e.getOrganizationalRoleId())).map(e -> e.getOrganizationalRoleId()).collect(Collectors.toList()));
        }
        return new LinkedHashSet<String>(Arrays.asList(this.getOrganizationalRoleId()));
    }

    @JsonIgnore
    @JSONField(serialize=false)
    default public String getPersonName() {
        return this.getDisplayName();
    }

    @JsonIgnore
    @JSONField(serialize=false)
    default public String getUserid() {
        return this.getId();
    }

    public static AuthenticationUser getAuthenticationUser() {
        AuthenticationUser authuserdetail;
        if (SecurityContextHolder.getContext() == null || SecurityContextHolder.getContext().getAuthentication() == null || SecurityContextHolder.getContext().getAuthentication().getPrincipal() == null) {
            return new BaseImpl();
        }
        Object userDetails = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (userDetails instanceof AuthenticationUser) {
            authuserdetail = (AuthenticationUser)userDetails;
        } else if (userDetails instanceof String) {
            authuserdetail = new BaseImpl();
            authuserdetail.setId(userDetails.toString());
            authuserdetail.setUsername(userDetails.toString());
        } else {
            authuserdetail = "net.ibizsys.central.cloud.core.security.AuthenticationUser".equals(userDetails.getClass().getName()) ? AuthenticationContextHolder.getContext() : BaseImpl.from(userDetails);
        }
        return authuserdetail;
    }

    public static AuthenticationUser setAuthenticationUser(AuthenticationUser user) {
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)user, null, user.getAuthorities());
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        return user;
    }

    public static class BaseImpl
    implements AuthenticationUser {
        public static Class<? extends AuthenticationUser> defaultUserClass = BaseImpl.class;
        static ThreadLocal<AuthenticationUser> contextHolder = new ThreadLocal();
        static ObjectMapper mapper = new ObjectMapper();
        @JsonIgnore
        @JSONField(serialize=false)
        private Map extensionparams;

        static synchronized AuthenticationUser from(Object obj) {
            AuthenticationUser ctx = contextHolder.get();
            if (ctx == null) {
                try {
                    Object user = obj;
                    if (!obj.getClass().isAssignableFrom(defaultUserClass)) {
                        user = mapper.readValue(mapper.writeValueAsString(obj), BaseImpl.class);
                    }
                    ctx = (AuthenticationUser)mapper.readValue(mapper.writeValueAsString(user), defaultUserClass);
                }
                catch (JsonProcessingException e) {
                    return null;
                }
                contextHolder.set(ctx);
            }
            return ctx;
        }

        @Override
        @JsonIgnore
        @JSONField(serialize=false)
        public Collection<GrantedAuthority> getAuthorities() {
            return null;
        }

        public Map getExtensionparams() {
            if (this.extensionparams == null) {
                Enumeration headerNames;
                HttpServletRequest request;
                this.extensionparams = new HashMap();
                ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
                if (requestAttributes != null && (request = requestAttributes.getRequest()) != null && (headerNames = request.getHeaderNames()) != null) {
                    while (headerNames.hasMoreElements()) {
                        String name = (String)headerNames.nextElement();
                        this.extensionparams.put(name, request.getHeader(name));
                    }
                }
            }
            return this.extensionparams;
        }
    }
}

